/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.JobRestController;
import com.netflix.genie.web.hateoas.resources.JobExecutionResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class JobExecutionResourceAssembler
implements ResourceAssembler<JobExecution, JobExecutionResource> {
    public JobExecutionResource toResource(JobExecution jobExecution) {
        JobExecutionResource jobExecutionResource = new JobExecutionResource(jobExecution);
        try {
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(jobExecution.getId()))).withSelfRel());
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(jobExecution.getId()))).withRel("job"));
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(jobExecution.getId()))).withRel("request"));
            String output = "output";
            jobExecutionResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)jobExecution.getId())).slash((Object)"output")).withRel("output"));
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(jobExecution.getId())).withRel("status"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobExecutionResource;
    }
}

