/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.JobRestController;
import com.netflix.genie.web.hateoas.resources.JobRequestResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class JobRequestResourceAssembler
implements ResourceAssembler<JobRequest, JobRequestResource> {
    public JobRequestResource toResource(JobRequest jobRequest) {
        JobRequestResource jobRequestResource = new JobRequestResource(jobRequest);
        try {
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(jobRequest.getId()))).withSelfRel());
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(jobRequest.getId()))).withRel("job"));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(jobRequest.getId()))).withRel("execution"));
            String output = "output";
            jobRequestResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)jobRequest.getId())).slash((Object)"output")).withRel("output"));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(jobRequest.getId())).withRel("status"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobRequestResource;
    }
}

