/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.JobRestController;
import com.netflix.genie.web.hateoas.resources.JobResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class JobResourceAssembler
implements ResourceAssembler<Job, JobResource> {
    public JobResource toResource(Job job) {
        JobResource jobResource = new JobResource(job);
        try {
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(job.getId()))).withSelfRel());
            String output = "output";
            jobResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)job.getId())).slash((Object)"output")).withRel("output"));
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(job.getId()))).withRel("request"));
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(job.getId()))).withRel("execution"));
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(job.getId())).withRel("status"));
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobCluster(job.getId()))).withRel("cluster"));
            jobResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobCommand(job.getId()))).withRel("command"));
            jobResource.add(ControllerLinkBuilder.linkTo(((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobApplications(job.getId())).withRel("applications"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobResource;
    }
}

