/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.netflix.genie.web.tasks.job.JobMonitoringCoordinator;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class GenieHealthIndicator
implements HealthIndicator {
    private static final String MAX_RUNNING_JOBS_KEY = "maxRunningJobs";
    private static final String NUMBER_RUNNING_JOBS_KEY = "numRunningJobs";
    private final JobMonitoringCoordinator jobMonitoringCoordinator;
    private final int maxRunningJobs;

    @Autowired
    public GenieHealthIndicator(@NotNull JobMonitoringCoordinator jobMonitoringCoordinator, @Value(value="${genie.jobs.max.running:2}") int maxRunningJobs) {
        this.jobMonitoringCoordinator = jobMonitoringCoordinator;
        this.maxRunningJobs = maxRunningJobs;
    }

    public Health health() {
        int numRunningJobs = this.jobMonitoringCoordinator.getNumJobs();
        if (numRunningJobs < this.maxRunningJobs) {
            return Health.up().withDetail(MAX_RUNNING_JOBS_KEY, (Object)this.maxRunningJobs).withDetail(NUMBER_RUNNING_JOBS_KEY, (Object)numRunningJobs).build();
        }
        return Health.outOfService().withDetail(MAX_RUNNING_JOBS_KEY, (Object)this.maxRunningJobs).withDetail(NUMBER_RUNNING_JOBS_KEY, (Object)numRunningJobs).build();
    }
}

