/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class MemoryHealthIndicator
implements HealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(MemoryHealthIndicator.class);
    private static final String FREE_PHYSICAL_MEMORY_SIZE = "freePhysicalMemorySize";
    private static final String TOTAL_PHYSICAL_MEMORY_SIZE = "totalPhysicalMemorySize";
    private final double maxUsedPhysicalMemoryPercentage;
    private final OperatingSystemMXBean operatingSystemMXBean;

    @Autowired
    public MemoryHealthIndicator(@Value(value="${genie.health.memory.usedPhysicalMemoryPercent:90}") double maxUsedPhysicalMemoryPercentage) {
        this(maxUsedPhysicalMemoryPercentage, (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean());
    }

    MemoryHealthIndicator(double maxUsedPhysicalMemoryPercentage, OperatingSystemMXBean operatingSystemMXBean) {
        this.maxUsedPhysicalMemoryPercentage = maxUsedPhysicalMemoryPercentage;
        this.operatingSystemMXBean = operatingSystemMXBean;
    }

    public Health health() {
        Health.Builder result = Health.up();
        try {
            double freePhysicalMemorySize = this.operatingSystemMXBean.getFreePhysicalMemorySize();
            double totalPhysicalMemorySize = this.operatingSystemMXBean.getTotalPhysicalMemorySize();
            double usedPhysicalMemoryPercentage = (totalPhysicalMemorySize - freePhysicalMemorySize) / totalPhysicalMemorySize * 100.0;
            if (usedPhysicalMemoryPercentage > this.maxUsedPhysicalMemoryPercentage) {
                log.warn("Physical memory {} crossed the threshold of {}", (Object)usedPhysicalMemoryPercentage, (Object)this.maxUsedPhysicalMemoryPercentage);
                result = Health.outOfService();
            }
            result.withDetail(FREE_PHYSICAL_MEMORY_SIZE, (Object)freePhysicalMemorySize).withDetail(TOTAL_PHYSICAL_MEMORY_SIZE, (Object)totalPhysicalMemorySize);
        }
        catch (Throwable e) {
            log.warn("Failed monitoring memory health indicator with error {}", (Object)e.getMessage());
        }
        return result.build();
    }
}

