/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class PingFederateRemoteTokenServices
extends RemoteTokenServices {
    private static final Logger log = LoggerFactory.getLogger(PingFederateRemoteTokenServices.class);
    protected static final String TOKEN_NAME_KEY = "token";
    protected static final String CLIENT_ID_KEY = "client_id";
    protected static final String CLIENT_SECRET_KEY = "client_secret";
    protected static final String GRANT_TYPE_KEY = "grant_type";
    protected static final String ERROR_KEY = "error";
    protected static final String SCOPE_KEY = "scope";
    protected static final String GRANT_TYPE = "urn:pingidentity.com:oauth2:grant_type:validate_bearer";
    protected static final String AUTHENTICATION_TIMER_NAME = "genie.security.oauth2.pingFederate.authentication.timer";
    protected static final String API_TIMER_NAME = "genie.security.oauth2.pingFederate.api.timer";
    private final AccessTokenConverter converter;
    private RestTemplate localRestTemplate;
    private final String checkTokenEndpointUrl;
    private final String clientId;
    private final String clientSecret;
    private final Id tokenValidationError;
    private final Timer authenticationTimer;
    private final Timer pingFederateAPITimer;

    public PingFederateRemoteTokenServices(@NotNull ResourceServerProperties serverProperties, @NotNull AccessTokenConverter converter, final @NotNull Registry registry) {
        this.tokenValidationError = registry.createId("genie.security.oauth2.pingFederate.tokenValidation.error.rate");
        this.authenticationTimer = registry.timer(AUTHENTICATION_TIMER_NAME);
        this.pingFederateAPITimer = registry.timer(API_TIMER_NAME);
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(2000);
        factory.setReadTimeout(10000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();
        interceptors.add((request, body, execution) -> {
            long start = System.nanoTime();
            try {
                ClientHttpResponse clientHttpResponse = execution.execute(request, body);
                return clientHttpResponse;
            }
            finally {
                this.pingFederateAPITimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        });
        restTemplate.setInterceptors(interceptors);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                int errorCode = response.getRawStatusCode();
                registry.counter(PingFederateRemoteTokenServices.this.tokenValidationError.withTag("status", Integer.toString(errorCode))).increment();
                if (response.getRawStatusCode() != HttpStatus.BAD_REQUEST.value()) {
                    super.handleError(response);
                }
            }
        });
        this.setRestTemplate(restTemplate);
        this.checkTokenEndpointUrl = serverProperties.getTokenInfoUri();
        this.clientId = serverProperties.getClientId();
        this.clientSecret = serverProperties.getClientSecret();
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)this.checkTokenEndpointUrl), (String)"Check Endpoint URL is required");
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"Client ID is required");
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"Client secret is required");
        log.debug("checkTokenEndpointUrl = {}", (Object)this.checkTokenEndpointUrl);
        log.debug("clientId = {}", (Object)this.clientId);
        log.debug("clientSecret = {}", (Object)this.clientSecret);
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        long start = System.nanoTime();
        try {
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            formData.add((Object)TOKEN_NAME_KEY, (Object)accessToken);
            formData.add((Object)CLIENT_ID_KEY, (Object)this.clientId);
            formData.add((Object)CLIENT_SECRET_KEY, (Object)this.clientSecret);
            formData.add((Object)GRANT_TYPE_KEY, (Object)GRANT_TYPE);
            Map<String, Object> map = this.postForMap(this.checkTokenEndpointUrl, (MultiValueMap<String, String>)formData);
            if (map.containsKey(ERROR_KEY)) {
                String error = map.get(ERROR_KEY).toString();
                log.debug("Validating the token produced an error: {}", (Object)error);
                throw new InvalidTokenException(error);
            }
            Assert.state((boolean)map.containsKey(CLIENT_ID_KEY), (String)"Client id must be present in response from auth server");
            Assert.state((boolean)map.containsKey(SCOPE_KEY), (String)"No scopes included in response from authentication server");
            this.convertScopes(map);
            OAuth2Authentication authentication = this.converter.extractAuthentication(map);
            log.info("User {} authenticated with authorities {}", authentication.getPrincipal(), (Object)authentication.getAuthorities());
            OAuth2Authentication oAuth2Authentication = authentication;
            return oAuth2Authentication;
        }
        finally {
            long finished = System.nanoTime();
            this.authenticationTimer.record(finished - start, TimeUnit.NANOSECONDS);
        }
    }

    protected void setRestTemplate(@NotNull RestTemplate restTemplate) {
        super.setRestTemplate((RestOperations)restTemplate);
        this.localRestTemplate = restTemplate;
    }

    private Map<String, Object> postForMap(String path, MultiValueMap<String, String> formData) {
        Map map;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        Map result = map = (Map)this.localRestTemplate.exchange(path, HttpMethod.POST, new HttpEntity(formData, (MultiValueMap)headers), Map.class, new Object[0]).getBody();
        return result;
    }

    private void convertScopes(Map<String, Object> oauth2Map) {
        String scopes;
        Object scopesObject = oauth2Map.get(SCOPE_KEY);
        if (scopesObject == null) {
            throw new InvalidTokenException("Scopes were null");
        }
        if (scopesObject instanceof String) {
            scopes = (String)scopesObject;
            if (StringUtils.isBlank((CharSequence)scopes)) {
                throw new InvalidTokenException("No scopes found unable to authenticate");
            }
        } else {
            throw new InvalidTokenException("Scopes was not a String");
        }
        oauth2Map.put(SCOPE_KEY, Arrays.asList(StringUtils.split((String)scopes, (char)' ')));
    }
}

