/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.x509;

import com.netflix.genie.web.security.SecurityUtils;
import com.netflix.genie.web.security.x509.X509UserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@ConditionalOnProperty(value={"genie.security.x509.enabled"})
@Configuration
@Order(value=4)
public class X509Config
extends WebSecurityConfigurerAdapter {
    @Autowired
    private X509UserDetailsService x509UserDetailsService;
    @Value(value="${management.context-path}")
    private String actuatorEndpoint;

    protected void configure(HttpSecurity http) throws Exception {
        SecurityUtils.buildAPIHttpSecurity(http, this.x509UserDetailsService, this.actuatorEndpoint);
    }
}

