/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.x509;

import com.google.common.collect.Sets;
import com.netflix.genie.web.security.SecurityConditions;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;

@Conditional(value={SecurityConditions.AnySecurityEnabled.class})
@Component
public class X509UserDetailsService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    private static final Logger log = LoggerFactory.getLogger(X509UserDetailsService.class);
    private static final String ROLE_PREFIX = "ROLE_";
    private static final GrantedAuthority USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");

    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        log.debug("Entering loadUserDetails with token {}", (Object)token);
        Object principalObject = token.getPrincipal();
        if (principalObject == null || !(principalObject instanceof String)) {
            throw new UsernameNotFoundException("Expected principal to be a String");
        }
        String principal = (String)principalObject;
        String[] usernameAndRoles = principal.split(":");
        if (usernameAndRoles.length != 2) {
            throw new UsernameNotFoundException("User and roles not found. Must be in format {user}:{role1,role2...}");
        }
        String username = usernameAndRoles[0];
        String[] roles = usernameAndRoles[1].split(",");
        if (roles.length == 0) {
            throw new UsernameNotFoundException("No roles found. Unable to authenticate");
        }
        HashSet authorities = Sets.newHashSet((Object[])new GrantedAuthority[]{USER_AUTHORITY});
        for (String role : roles) {
            authorities.add(new SimpleGrantedAuthority(ROLE_PREFIX + role.toUpperCase()));
        }
        User user = new User(username, "NA", (Collection)authorities);
        log.info("User {} authenticated via client certificate", (Object)user);
        return user;
    }
}

