/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.dto.BaseDTO;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.core.events.JobFinishedEvent;
import com.netflix.genie.core.events.JobFinishedReason;
import com.netflix.genie.core.jobs.JobConstants;
import com.netflix.genie.core.jobs.JobDoneFile;
import com.netflix.genie.core.services.JobPersistenceService;
import com.netflix.genie.core.services.JobSearchService;
import com.netflix.genie.core.services.MailService;
import com.netflix.genie.core.services.impl.GenieFileTransferService;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class JobCompletionHandler {
    private static final Logger log = LoggerFactory.getLogger(JobCompletionHandler.class);
    private static final String STATUS_TAG = "status";
    private static final String ERROR_TAG = "error";
    private final JobPersistenceService jobPersistenceService;
    private final JobSearchService jobSearchService;
    private final GenieFileTransferService genieFileTransferService;
    private final String baseWorkingDir;
    private final MailService mailServiceImpl;
    private final Executor executor;
    private final boolean deleteArchiveFile;
    private final boolean deleteDependencies;
    private final boolean isRunAsUserEnabled;
    private final Registry registry;
    private final Id jobCompletionId;
    private final Counter emailSuccessRate;
    private final Counter emailFailureRate;
    private final Counter archivalFailureRate;
    private final Counter doneFileProcessingFailureRate;
    private final Counter finalStatusUpdateFailureRate;
    private final Counter processGroupCleanupFailureRate;
    private final Counter archiveFileDeletionFailure;
    private final Counter deleteDependenciesFailure;

    @Autowired
    public JobCompletionHandler(JobPersistenceService jobPersistenceService, JobSearchService jobSearchService, GenieFileTransferService genieFileTransferService, Resource genieWorkingDir, MailService mailServiceImpl, Registry registry, @Value(value="${genie.jobs.cleanup.deleteArchiveFile.enabled:true}") boolean deleteArchiveFile, @Value(value="${genie.jobs.cleanup.deleteDependencies.enabled:true}") boolean deleteDependencies, @Value(value="${genie.jobs.runAsUser.enabled:false}") boolean isRunAsUserEnabled) throws GenieException {
        this.jobPersistenceService = jobPersistenceService;
        this.jobSearchService = jobSearchService;
        this.genieFileTransferService = genieFileTransferService;
        this.mailServiceImpl = mailServiceImpl;
        this.deleteArchiveFile = deleteArchiveFile;
        this.deleteDependencies = deleteDependencies;
        this.isRunAsUserEnabled = isRunAsUserEnabled;
        this.executor = new DefaultExecutor();
        this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, null));
        try {
            this.baseWorkingDir = genieWorkingDir.getFile().getCanonicalPath();
        }
        catch (IOException gse) {
            throw new GenieServerException("Could not load the base path from resource");
        }
        this.registry = registry;
        this.jobCompletionId = registry.createId("genie.jobs.completion.timer");
        this.emailSuccessRate = registry.counter("genie.jobs.email.success.rate");
        this.emailFailureRate = registry.counter("genie.jobs.email.failure.rate");
        this.archivalFailureRate = registry.counter("genie.jobs.archivalFailure.rate");
        this.doneFileProcessingFailureRate = registry.counter("genie.jobs.doneFileProcessingFailure.rate");
        this.finalStatusUpdateFailureRate = registry.counter("genie.jobs.finalStatusUpdateFailure.rate");
        this.processGroupCleanupFailureRate = registry.counter("genie.jobs.processGroupCleanupFailure.rate");
        this.archiveFileDeletionFailure = registry.counter("genie.jobs.archiveFileDeletionFailure.rate");
        this.deleteDependenciesFailure = registry.counter("genie.jobs.deleteDependenciesFailure.rate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventListener
    public void handleJobCompletion(JobFinishedEvent event) throws GenieException {
        Id timerId;
        long start;
        block19: {
            start = System.nanoTime();
            timerId = null;
            try {
                String jobId = event.getId();
                Job job = this.jobSearchService.getJob(jobId);
                JobStatus status = job.getStatus();
                if (status != JobStatus.FAILED && status != JobStatus.INVALID && status != JobStatus.KILLED && status != JobStatus.SUCCEEDED) {
                    if (status == JobStatus.INIT) {
                        try {
                            switch (event.getReason()) {
                                case KILLED: {
                                    this.jobPersistenceService.updateJobStatus(jobId, JobStatus.KILLED, event.getMessage());
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.KILLED.toString());
                                    break;
                                }
                                case INVALID: {
                                    this.jobPersistenceService.updateJobStatus(jobId, JobStatus.INVALID, event.getMessage());
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.INVALID.toString());
                                    break;
                                }
                                case FAILED_TO_INIT: {
                                    this.jobPersistenceService.updateJobStatus(jobId, JobStatus.FAILED, event.getMessage());
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.FAILED.toString());
                                    break;
                                }
                                case PROCESS_COMPLETED: {
                                    this.jobPersistenceService.updateJobStatus(jobId, JobStatus.SUCCEEDED, event.getMessage());
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.SUCCEEDED.toString());
                                    break;
                                }
                                case SYSTEM_CRASH: {
                                    this.jobPersistenceService.updateJobStatus(jobId, JobStatus.FAILED, event.getMessage());
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.FAILED.toString());
                                    break;
                                }
                                default: {
                                    log.error("Unknown case: " + event.getReason());
                                    this.finalStatusUpdateFailureRate.increment();
                                    timerId = this.jobCompletionId.withTag(STATUS_TAG, "exception").withTag(ERROR_TAG, event.getReason().toString());
                                    break;
                                }
                            }
                        }
                        catch (GenieException ge) {
                            this.finalStatusUpdateFailureRate.increment();
                        }
                    } else if (status == JobStatus.RUNNING) {
                        if (event.getReason() != JobFinishedReason.SYSTEM_CRASH) {
                            timerId = this.jobCompletionId.withTag(STATUS_TAG, this.updateFinalStatusForJob(jobId).toString());
                            this.cleanupProcesses(jobId);
                        } else {
                            this.jobPersistenceService.updateJobStatus(jobId, JobStatus.FAILED, event.getMessage());
                            timerId = this.jobCompletionId.withTag(STATUS_TAG, JobStatus.FAILED.toString());
                        }
                    }
                    this.processJobDir(jobId);
                    this.sendEmail(jobId);
                }
                if (timerId != null) break block19;
            }
            catch (Throwable throwable) {
                if (timerId == null) {
                    timerId = this.jobCompletionId.withTag(STATUS_TAG, ERROR_TAG).withTag(ERROR_TAG, "Unknown");
                }
                this.registry.timer(timerId).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                throw throwable;
            }
            timerId = this.jobCompletionId.withTag(STATUS_TAG, ERROR_TAG).withTag(ERROR_TAG, "Unknown");
        }
        this.registry.timer(timerId).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    private void cleanupProcesses(String jobId) {
        try {
            int pid = this.jobSearchService.getJobExecution(jobId).getProcessId();
            try {
                CommandLine commandLine = new CommandLine("pkill");
                commandLine.addArgument(JobConstants.getKillFlag());
                commandLine.addArgument(Integer.toString(pid));
                this.executor.execute(commandLine);
                this.processGroupCleanupFailureRate.increment();
            }
            catch (Exception e) {
                log.debug("Received expected exception. Ignoring.");
            }
        }
        catch (GenieException ge) {
            log.error("Unable to get job execution so unable to cleanup process for job " + jobId, (Throwable)ge);
            this.processGroupCleanupFailureRate.increment();
        }
    }

    private JobStatus updateFinalStatusForJob(String id) throws GenieException {
        try {
            log.debug("Updating the status of the job.");
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JobStatus finalStatus;
                JobDoneFile jobDoneFile = (JobDoneFile)objectMapper.readValue(new File(this.baseWorkingDir + "/" + id + "/genie/genie.done"), JobDoneFile.class);
                int exitCode = jobDoneFile.getExitCode();
                switch (exitCode) {
                    case 999: {
                        this.jobPersistenceService.setJobCompletionInformation(id, exitCode, JobStatus.KILLED, "Job was killed.");
                        finalStatus = JobStatus.KILLED;
                        break;
                    }
                    case 0: {
                        this.jobPersistenceService.setJobCompletionInformation(id, exitCode, JobStatus.SUCCEEDED, "Job finished successfully.");
                        finalStatus = JobStatus.SUCCEEDED;
                        break;
                    }
                    default: {
                        this.jobPersistenceService.setJobCompletionInformation(id, exitCode, JobStatus.FAILED, "Job failed.");
                        finalStatus = JobStatus.FAILED;
                    }
                }
                return finalStatus;
            }
            catch (IOException ioe) {
                this.doneFileProcessingFailureRate.increment();
                log.error("Could not load the done file for job {}. Marking it as failed.", (Object)id);
                this.jobPersistenceService.updateJobStatus(id, JobStatus.FAILED, "Genie could not load done file.");
                return JobStatus.FAILED;
            }
        }
        catch (Exception e) {
            log.error("Could not update the exit code and status for job: {}", (Object)id, (Object)e);
            this.finalStatusUpdateFailureRate.increment();
            throw e;
        }
    }

    private void deleteApplicationDependencies(String jobId, String jobWorkingDir) {
        log.debug("Deleting dependencies as its enabled.");
        File jobDir = new File(jobWorkingDir);
        if (jobDir.exists()) {
            try {
                List appIds = this.jobSearchService.getJobApplications(jobId).stream().map(BaseDTO::getId).collect(Collectors.toList());
                for (String appId : appIds) {
                    CommandLine deleteCommand;
                    String applicationDependencyFolder = jobWorkingDir + "/" + "genie" + "/" + "applications" + "/" + appId + "/" + "dependencies";
                    File appDependencyDir = new File(applicationDependencyFolder);
                    if (!appDependencyDir.exists()) continue;
                    if (this.isRunAsUserEnabled) {
                        deleteCommand = new CommandLine("sudo");
                        deleteCommand.addArgument("rm");
                    } else {
                        deleteCommand = new CommandLine("rm");
                    }
                    deleteCommand.addArgument("-rf");
                    deleteCommand.addArgument(applicationDependencyFolder);
                    log.debug("Delete command is {}", (Object)deleteCommand.toString());
                    this.executor.execute(deleteCommand);
                }
            }
            catch (Exception e) {
                log.error("Could not delete job dependencies after completion for job: {} due to error {}", (Object)jobId, (Object)e);
                this.deleteDependenciesFailure.increment();
            }
        }
    }

    private void processJobDir(String jobId) throws GenieException {
        log.debug("Got a job finished event. Will process job directory.");
        Job job = this.jobSearchService.getJob(jobId);
        String jobWorkingDir = this.baseWorkingDir + "/" + jobId;
        File jobDir = new File(jobWorkingDir);
        if (jobDir.exists()) {
            if (this.deleteDependencies) {
                this.deleteApplicationDependencies(jobId, jobWorkingDir);
            }
            try {
                if (StringUtils.isNotBlank((String)job.getArchiveLocation())) {
                    log.debug("Archiving job directory");
                    String localArchiveFile = jobWorkingDir + "/" + "genie/logs/" + jobId + ".tar.gz";
                    CommandLine commandLine = new CommandLine("sudo");
                    commandLine.addArgument("tar");
                    commandLine.addArgument("-c");
                    commandLine.addArgument("-z");
                    commandLine.addArgument("-f");
                    commandLine.addArgument(localArchiveFile);
                    commandLine.addArgument("./");
                    this.executor.setWorkingDirectory(jobDir);
                    log.debug("Archive command : {}", (Object)commandLine.toString());
                    this.executor.execute(commandLine);
                    this.genieFileTransferService.putFile(localArchiveFile, job.getArchiveLocation());
                    if (this.deleteArchiveFile) {
                        log.debug("Deleting archive file");
                        try {
                            new File(localArchiveFile).delete();
                        }
                        catch (Exception e) {
                            log.error("Failed to delete archive file for job: {}", (Object)jobId, (Object)e);
                            this.archiveFileDeletionFailure.increment();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Could not archive directory for job: {}", (Object)jobId, (Object)e);
                this.archivalFailureRate.increment();
            }
        }
    }

    private void sendEmail(String jobId) throws GenieException {
        try {
            log.debug("Got a job finished event. Sending email.");
            JobRequest jobRequest = this.jobSearchService.getJobRequest(jobId);
            if (StringUtils.isNotBlank((String)jobRequest.getEmail())) {
                JobStatus status = this.jobSearchService.getJobStatus(jobId);
                this.mailServiceImpl.sendEmail(jobRequest.getEmail(), "Genie Job" + jobId, "Job with id [" + jobId + "] finished with status " + status);
                this.emailSuccessRate.increment();
            }
        }
        catch (Exception e) {
            log.error("Could not send email for job: {}", (Object)jobId, (Object)e);
            this.emailFailureRate.increment();
        }
    }
}

