/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.cluster.leader.event.OnGrantedEvent;
import org.springframework.cloud.cluster.leader.event.OnRevokedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

public class LocalLeader {
    private static final Logger log = LoggerFactory.getLogger(LocalLeader.class);
    private final ApplicationEventPublisher publisher;
    private final boolean isLeader;

    public LocalLeader(ApplicationEventPublisher publisher, boolean isLeader) {
        this.publisher = publisher;
        this.isLeader = isLeader;
        if (this.isLeader) {
            log.info("Constructing LocalLeader. This node IS the leader.");
        } else {
            log.info("Constructing LocalLeader. This node IS NOT the leader.");
        }
    }

    @EventListener
    public void startLeadership(ApplicationReadyEvent event) {
        if (this.isLeader) {
            log.debug("Starting Leadership due to " + event);
            this.publisher.publishEvent((ApplicationEvent)new OnGrantedEvent((Object)this, null, "leader"));
        }
    }

    @EventListener
    public void stopLeadership(ContextClosedEvent event) {
        if (this.isLeader) {
            log.debug("Stopping Leadership due to " + event);
            this.publisher.publishEvent((ApplicationEvent)new OnRevokedEvent((Object)this, null, "leader"));
        }
    }
}

