/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.jobs.workflow.WorkflowTask;
import com.netflix.genie.core.jobs.workflow.impl.ApplicationTask;
import com.netflix.genie.core.jobs.workflow.impl.ClusterTask;
import com.netflix.genie.core.jobs.workflow.impl.CommandTask;
import com.netflix.genie.core.jobs.workflow.impl.InitialSetupTask;
import com.netflix.genie.core.jobs.workflow.impl.JobFailureAndKillHandlerLogicTask;
import com.netflix.genie.core.jobs.workflow.impl.JobKickoffTask;
import com.netflix.genie.core.jobs.workflow.impl.JobTask;
import com.netflix.genie.core.services.AttachmentService;
import com.netflix.genie.core.services.FileTransfer;
import com.netflix.genie.core.services.impl.GenieFileTransferService;
import com.netflix.genie.core.services.impl.LocalFileTransferImpl;
import com.netflix.spectator.api.Registry;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class JobConfig {
    @Bean(name={"file.system.file", "file.system.null"})
    @Order(value=2)
    public FileTransfer localFileTransfer() {
        return new LocalFileTransferImpl();
    }

    @Bean
    @Order(value=0)
    public WorkflowTask jobKillLogicTask(Registry registry) {
        return new JobFailureAndKillHandlerLogicTask(registry);
    }

    @Bean
    @Order(value=1)
    public WorkflowTask initialSetupTask(Registry registry) {
        return new InitialSetupTask(registry);
    }

    @Bean
    @Order(value=2)
    public WorkflowTask clusterProcessorTask(Registry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ClusterTask(registry, fts);
    }

    @Bean
    @Order(value=3)
    public WorkflowTask applicationProcessorTask(Registry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ApplicationTask(registry, fts);
    }

    @Bean
    @Order(value=4)
    public WorkflowTask commandProcessorTask(Registry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new CommandTask(registry, fts);
    }

    @Bean
    @Order(value=5)
    @Autowired
    public WorkflowTask jobProcessorTask(AttachmentService attachmentService, Registry registry, @Qualifier(value="genieFileTransferService") GenieFileTransferService fts) throws GenieException {
        return new JobTask(attachmentService, registry, fts);
    }

    @Bean
    @Order(value=6)
    @Autowired
    public WorkflowTask jobKickoffTask(@Value(value="${genie.jobs.runAsUser.enabled:false}") boolean isRunAsUserEnabled, @Value(value="${genie.jobs.createUser.enabled:false}") boolean isUserCreationEnabled, Executor executor, String hostName, Registry registry) {
        return new JobKickoffTask(isRunAsUserEnabled, isUserCreationEnabled, executor, hostName, registry);
    }
}

