/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.services.CommandService;
import com.netflix.genie.web.hateoas.assemblers.ApplicationResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.ClusterResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.hateoas.resources.ApplicationResource;
import com.netflix.genie.web.hateoas.resources.ClusterResource;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/commands"})
public class CommandRestController {
    private static final Logger log = LoggerFactory.getLogger(CommandRestController.class);
    private final CommandService commandService;
    private final CommandResourceAssembler commandResourceAssembler;
    private final ApplicationResourceAssembler applicationResourceAssembler;
    private final ClusterResourceAssembler clusterResourceAssembler;

    @Autowired
    public CommandRestController(CommandService commandService, CommandResourceAssembler commandResourceAssembler, ApplicationResourceAssembler applicationResourceAssembler, ClusterResourceAssembler clusterResourceAssembler) {
        this.commandService = commandService;
        this.commandResourceAssembler = commandResourceAssembler;
        this.applicationResourceAssembler = applicationResourceAssembler;
        this.clusterResourceAssembler = clusterResourceAssembler;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createCommand(@RequestBody Command command) throws GenieException {
        log.debug("called to create new command configuration {}", (Object)command);
        String id = this.commandService.createCommand(command);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public CommandResource getCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called to get command with id {}", (Object)id);
        return this.commandResourceAssembler.toResource(this.commandService.getCommand(id));
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<CommandResource> getCommands(@RequestParam(value="name", required=false) String name, @RequestParam(value="user", required=false) String user, @RequestParam(value="status", required=false) Set<String> statuses, @RequestParam(value="tag", required=false) Set<String> tags, @PageableDefault(page=0, size=64, sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<Command> assembler) throws GenieException {
        log.debug("Called [name | user | status | tags | page]");
        log.debug("{} | {} | {} | {} | {}", new Object[]{name, user, statuses, tags, page});
        EnumSet<CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(CommandStatus.parse((String)status));
            }
        }
        Link self = ControllerLinkBuilder.linkTo(((CommandRestController)ControllerLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getCommands(name, user, statuses, tags, page, assembler)).withSelfRel();
        return assembler.toResource(this.commandService.getCommands(name, user, enumStatuses, tags, page), (ResourceAssembler)this.commandResourceAssembler, self);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCommand(@PathVariable(value="id") String id, @RequestBody Command updateCommand) throws GenieException {
        log.debug("Called to update command {}", (Object)updateCommand);
        this.commandService.updateCommand(id, updateCommand);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchCommand(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.debug("Called to patch command {} with patch {}", (Object)id, (Object)patch);
        this.commandService.patchCommand(id, patch);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllCommands() throws GenieException {
        log.debug("called to delete all commands.");
        this.commandService.deleteAllCommands();
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called to delete command with id {}", (Object)id);
        this.commandService.deleteCommand(id);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and config {}", (Object)id, configs);
        this.commandService.addConfigsForCommand(id, configs);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.commandService.getConfigsForCommand(id);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and configs {}", (Object)id, configs);
        this.commandService.updateConfigsForCommand(id, configs);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.commandService.removeAllConfigsForCommand(id);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and tags {}", (Object)id, tags);
        this.commandService.addTagsForCommand(id, tags);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.commandService.getTagsForCommand(id);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and tags {}", (Object)id, tags);
        this.commandService.updateTagsForCommand(id, tags);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.commandService.removeAllTagsForCommand(id);
    }

    @RequestMapping(value={"/{id}/tags/{tag}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForCommand(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.debug("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.commandService.removeTagForCommand(id, tag);
    }

    @RequestMapping(value={"/{id}/applications"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addApplicationsForCommand(@PathVariable(value="id") String id, @RequestBody List<String> applicationIds) throws GenieException {
        log.debug("Called with id {} and application {}", (Object)id, applicationIds);
        this.commandService.addApplicationsForCommand(id, applicationIds);
    }

    @RequestMapping(value={"/{id}/applications"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ApplicationResource> getApplicationsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.commandService.getApplicationsForCommand(id).stream().map(this.applicationResourceAssembler::toResource).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{id}/applications"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setApplicationsForCommand(@PathVariable(value="id") String id, @RequestBody List<String> applicationIds) throws GenieException {
        log.debug("Called with id {} and application {}", (Object)id, applicationIds);
        this.commandService.setApplicationsForCommand(id, applicationIds);
    }

    @RequestMapping(value={"/{id}/applications"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllApplicationsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id '{}'.", (Object)id);
        this.commandService.removeApplicationsForCommand(id);
    }

    @RequestMapping(value={"/{id}/applications/{appId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeApplicationForCommand(@PathVariable(value="id") String id, @PathVariable(value="appId") String appId) throws GenieException {
        log.debug("Called with id '{}' and app id {}", (Object)id, (Object)appId);
        this.commandService.removeApplicationForCommand(id, appId);
    }

    @RequestMapping(value={"/{id}/clusters"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<ClusterResource> getClustersForCommand(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) Set<String> statuses) throws GenieException {
        log.debug("Called with id {} and statuses {}", (Object)id, statuses);
        EnumSet<ClusterStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(ClusterStatus.class);
            for (String status : statuses) {
                enumStatuses.add(ClusterStatus.parse((String)status));
            }
        }
        return this.commandService.getClustersForCommand(id, enumStatuses).stream().map(this.clusterResourceAssembler::toResource).collect(Collectors.toSet());
    }
}

