/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.io.ByteStreams;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.core.services.AttachmentService;
import com.netflix.genie.core.services.JobCoordinatorService;
import com.netflix.genie.core.services.JobSearchService;
import com.netflix.genie.web.controllers.ControllerUtils;
import com.netflix.genie.web.hateoas.assemblers.ApplicationResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.ClusterResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.JobExecutionResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.JobRequestResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.JobResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.JobSearchResultResourceAssembler;
import com.netflix.genie.web.hateoas.resources.ApplicationResource;
import com.netflix.genie.web.hateoas.resources.ClusterResource;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import com.netflix.genie.web.hateoas.resources.JobExecutionResource;
import com.netflix.genie.web.hateoas.resources.JobRequestResource;
import com.netflix.genie.web.hateoas.resources.JobResource;
import com.netflix.genie.web.hateoas.resources.JobSearchResultResource;
import com.netflix.genie.web.properties.JobForwardingProperties;
import com.netflix.genie.web.resources.handlers.GenieResourceHttpRequestHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/jobs"})
public class JobRestController {
    private static final Logger log = LoggerFactory.getLogger(JobRestController.class);
    private static final String FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String NAME_HEADER_COOKIE = "cookie";
    private final JobCoordinatorService jobCoordinatorService;
    private final JobSearchService jobSearchService;
    private final AttachmentService attachmentService;
    private final ApplicationResourceAssembler applicationResourceAssembler;
    private final ClusterResourceAssembler clusterResourceAssembler;
    private final CommandResourceAssembler commandResourceAssembler;
    private final JobResourceAssembler jobResourceAssembler;
    private final JobRequestResourceAssembler jobRequestResourceAssembler;
    private final JobExecutionResourceAssembler jobExecutionResourceAssembler;
    private final JobSearchResultResourceAssembler jobSearchResultResourceAssembler;
    private final String hostName;
    private final RestTemplate restTemplate;
    private final GenieResourceHttpRequestHandler resourceHttpRequestHandler;
    private final JobForwardingProperties jobForwardingProperties;
    private final Counter submitJobWithoutAttachmentsRate;
    private final Counter submitJobWithAttachmentsRate;

    @Autowired
    public JobRestController(JobCoordinatorService jobCoordinatorService, JobSearchService jobSearchService, AttachmentService attachmentService, ApplicationResourceAssembler applicationResourceAssembler, ClusterResourceAssembler clusterResourceAssembler, CommandResourceAssembler commandResourceAssembler, JobResourceAssembler jobResourceAssembler, JobRequestResourceAssembler jobRequestResourceAssembler, JobExecutionResourceAssembler jobExecutionResourceAssembler, JobSearchResultResourceAssembler jobSearchResultResourceAssembler, String hostName, @Qualifier(value="genieRestTemplate") RestTemplate restTemplate, GenieResourceHttpRequestHandler resourceHttpRequestHandler, JobForwardingProperties jobForwardingProperties, Registry registry) {
        this.jobCoordinatorService = jobCoordinatorService;
        this.jobSearchService = jobSearchService;
        this.attachmentService = attachmentService;
        this.applicationResourceAssembler = applicationResourceAssembler;
        this.clusterResourceAssembler = clusterResourceAssembler;
        this.commandResourceAssembler = commandResourceAssembler;
        this.jobResourceAssembler = jobResourceAssembler;
        this.jobRequestResourceAssembler = jobRequestResourceAssembler;
        this.jobExecutionResourceAssembler = jobExecutionResourceAssembler;
        this.jobSearchResultResourceAssembler = jobSearchResultResourceAssembler;
        this.hostName = hostName;
        this.restTemplate = restTemplate;
        this.resourceHttpRequestHandler = resourceHttpRequestHandler;
        this.jobForwardingProperties = jobForwardingProperties;
        this.submitJobWithoutAttachmentsRate = registry.counter("genie.api.v3.jobs.submitJobWithoutAttachments.rate");
        this.submitJobWithAttachmentsRate = registry.counter("genie.api.v3.jobs.submitJobWithAttachments.rate");
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<Void> submitJob(@Valid @RequestBody JobRequest jobRequest, @RequestHeader(value="X-Forwarded-For", required=false) String clientHost, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletRequest httpServletRequest) throws GenieException {
        log.info("[submitJob] Called json method type to submit job: {}", (Object)jobRequest);
        this.submitJobWithoutAttachmentsRate.increment();
        return this.handleSubmitJob(jobRequest, null, clientHost, userAgent, httpServletRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<Void> submitJob(@Valid @RequestPart(value="request") JobRequest jobRequest, @RequestPart(value="attachment") MultipartFile[] attachments, @RequestHeader(value="X-Forwarded-For", required=false) String clientHost, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletRequest httpServletRequest) throws GenieException {
        log.info("[submitJob] Called multipart method to submit job: {}", (Object)jobRequest);
        this.submitJobWithAttachmentsRate.increment();
        return this.handleSubmitJob(jobRequest, attachments, clientHost, userAgent, httpServletRequest);
    }

    private ResponseEntity<Void> handleSubmitJob(JobRequest jobRequest, MultipartFile[] attachments, String clientHost, String userAgent, HttpServletRequest httpServletRequest) throws GenieException {
        JobRequest jobRequestWithId;
        String jobId;
        if (jobRequest == null) {
            throw new GeniePreconditionException("No job request entered. Unable to submit.");
        }
        String localClientHost = StringUtils.isNotBlank((CharSequence)clientHost) ? clientHost.split(",")[0] : httpServletRequest.getRemoteAddr();
        Optional jobIdOptional = jobRequest.getId();
        if (jobIdOptional.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)jobIdOptional.get()))) {
            jobId = (String)jobIdOptional.get();
            jobRequestWithId = jobRequest;
        } else {
            jobId = UUID.randomUUID().toString();
            JobRequest.Builder builder = ((JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequest.getName(), jobRequest.getUser(), jobRequest.getVersion(), jobRequest.getCommandArgs(), jobRequest.getClusterCriterias(), jobRequest.getCommandCriteria()).withId(jobId)).withDisableLogArchival(jobRequest.isDisableLogArchival()).withTags(jobRequest.getTags())).withDependencies(jobRequest.getDependencies());
            jobRequest.getCpu().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withCpu(arg_0));
            jobRequest.getMemory().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMemory(arg_0));
            jobRequest.getGroup().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroup(arg_0));
            jobRequest.getSetupFile().ifPresent(x$0 -> builder.withSetupFile(x$0));
            jobRequest.getDescription().ifPresent(x$0 -> builder.withDescription(x$0));
            jobRequest.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withEmail(arg_0));
            jobRequest.getTimeout().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withTimeout(arg_0));
            jobRequestWithId = builder.build();
        }
        int numAttachments = 0;
        long totalSizeOfAttachments = 0L;
        if (attachments != null) {
            log.info("Saving attachments for job {}", (Object)jobId);
            numAttachments = attachments.length;
            for (MultipartFile attachment : attachments) {
                totalSizeOfAttachments += attachment.getSize();
                log.debug("Attachment name: {} Size: {}", (Object)attachment.getOriginalFilename(), (Object)attachment.getSize());
                try {
                    this.attachmentService.save(jobId, attachment.getOriginalFilename(), attachment.getInputStream());
                }
                catch (IOException ioe) {
                    throw new GenieServerException((Throwable)ioe);
                }
            }
        }
        JobMetadata metadata = new JobMetadata.Builder().withClientHost(localClientHost).withUserAgent(userAgent).withNumAttachments(Integer.valueOf(numAttachments)).withTotalSizeOfAttachments(Long.valueOf(totalSizeOfAttachments)).build();
        this.jobCoordinatorService.coordinateJob(jobRequestWithId, metadata);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{jobId}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    public JobResource getJob(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJob] Called for job with id: {}", (Object)id);
        return this.jobResourceAssembler.toResource(this.jobSearchService.getJob(id));
    }

    @RequestMapping(value={"/{id}/status"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getJobStatus(@PathVariable(value="id") String id) throws GenieException {
        log.debug("[getJobStatus] Called for job with id: {}", (Object)id);
        JsonNodeFactory factory = JsonNodeFactory.instance;
        return factory.objectNode().set("status", (JsonNode)factory.textNode(this.jobSearchService.getJobStatus(id).toString()));
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<JobSearchResultResource> findJobs(@RequestParam(value="id", required=false) String id, @RequestParam(value="name", required=false) String name, @RequestParam(value="user", required=false) String user, @RequestParam(value="status", required=false) Set<String> statuses, @RequestParam(value="tag", required=false) Set<String> tags, @RequestParam(value="clusterName", required=false) String clusterName, @RequestParam(value="clusterId", required=false) String clusterId, @RequestParam(value="commandName", required=false) String commandName, @RequestParam(value="commandId", required=false) String commandId, @RequestParam(value="minStarted", required=false) Long minStarted, @RequestParam(value="maxStarted", required=false) Long maxStarted, @RequestParam(value="minFinished", required=false) Long minFinished, @RequestParam(value="maxFinished", required=false) Long maxFinished, @PageableDefault(sort={"created"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<JobSearchResult> assembler) throws GenieException {
        log.info("[getJobs] Called with [id | jobName | user | statuses | clusterName | clusterId | minStarted | maxStarted | minFinished | maxFinished | page]");
        log.info("{} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {}", new Object[]{id, name, user, statuses, tags, clusterName, clusterId, commandName, commandId, minStarted, maxStarted, minFinished, maxFinished, page});
        EnumSet<JobStatus> enumStatuses = null;
        if (statuses != null && !statuses.isEmpty()) {
            enumStatuses = EnumSet.noneOf(JobStatus.class);
            for (String status : statuses) {
                if (!StringUtils.isNotBlank((CharSequence)status)) continue;
                enumStatuses.add(JobStatus.parse((String)status));
            }
        }
        Link self = ControllerLinkBuilder.linkTo(((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).findJobs(id, name, user, statuses, tags, clusterName, clusterId, commandName, commandId, minStarted, maxStarted, minFinished, maxFinished, page, assembler)).withSelfRel();
        return assembler.toResource(this.jobSearchService.findJobs(id, name, user, enumStatuses, tags, clusterName, clusterId, commandName, commandId, minStarted == null ? null : new Date(minStarted), maxStarted == null ? null : new Date(maxStarted), minFinished == null ? null : new Date(minFinished), maxFinished == null ? null : new Date(maxFinished), page), (ResourceAssembler)this.jobSearchResultResourceAssembler, self);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void killJob(@PathVariable(value="id") String id, @RequestHeader(name="Genie-Forwarded-From", required=false) String forwardedFrom, HttpServletRequest request, final HttpServletResponse response) throws GenieException, IOException, ServletException {
        String jobHostname;
        log.info("[killJob] Called for job id: {}. Forwarded from: {}", (Object)id, (Object)forwardedFrom);
        if (this.jobForwardingProperties.isEnabled() && forwardedFrom == null && !this.hostName.equals(jobHostname = this.jobSearchService.getJobHost(id))) {
            log.info("Job {} is not on this node. Forwarding kill request to {}", (Object)id, (Object)jobHostname);
            String forwardUrl = this.buildForwardURL(request, jobHostname);
            try {
                this.restTemplate.execute(forwardUrl, HttpMethod.DELETE, forwardRequest -> this.copyRequestHeaders(request, forwardRequest), (ResponseExtractor)new ResponseExtractor<Void>(){

                    public Void extractData(ClientHttpResponse forwardResponse) throws IOException {
                        response.setStatus(HttpStatus.ACCEPTED.value());
                        JobRestController.this.copyResponseHeaders(response, forwardResponse);
                        return null;
                    }
                }, new Object[0]);
            }
            catch (HttpStatusCodeException e) {
                log.error("Failed killing job on {}. Error: {}", (Object)forwardUrl, (Object)e.getMessage());
                response.sendError(e.getStatusCode().value(), e.getStatusText());
            }
            catch (Exception e) {
                log.error("Failed killing job on {}. Error: {}", (Object)forwardUrl, (Object)e.getMessage());
                response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
            }
            return;
        }
        log.info("Job {} is on this node. Attempting to kill.", (Object)id);
        this.jobCoordinatorService.killJob(id);
        response.setStatus(HttpStatus.ACCEPTED.value());
    }

    @RequestMapping(value={"/{id}/request"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public JobRequestResource getJobRequest(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobRequest] Called for job request with id {}", (Object)id);
        return this.jobRequestResourceAssembler.toResource(this.jobSearchService.getJobRequest(id));
    }

    @RequestMapping(value={"/{id}/execution"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public JobExecutionResource getJobExecution(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobExecution] Called for job execution with id {}", (Object)id);
        return this.jobExecutionResourceAssembler.toResource(this.jobSearchService.getJobExecution(id));
    }

    @RequestMapping(value={"/{id}/cluster"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ClusterResource getJobCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobCluster] Called for job with id {}", (Object)id);
        return this.clusterResourceAssembler.toResource(this.jobSearchService.getJobCluster(id));
    }

    @RequestMapping(value={"/{id}/command"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public CommandResource getJobCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobCommand] Called for job with id {}", (Object)id);
        return this.commandResourceAssembler.toResource(this.jobSearchService.getJobCommand(id));
    }

    @RequestMapping(value={"/{id}/applications"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ApplicationResource> getJobApplications(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobApplications] Called for job with id {}", (Object)id);
        return this.jobSearchService.getJobApplications(id).stream().map(this.applicationResourceAssembler::toResource).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{id}/output", "/{id}/output/", "/{id}/output/**"}, method={RequestMethod.GET}, produces={"*/*"})
    public void getJobOutput(@PathVariable(value="id") String id, @RequestHeader(name="Genie-Forwarded-From", required=false) String forwardedFrom, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException, GenieException {
        String jobHostname;
        log.info("[getJobOutput] Called for job with id: {}", (Object)id);
        if (this.jobForwardingProperties.isEnabled() && forwardedFrom == null && !this.hostName.equals(jobHostname = this.jobSearchService.getJobHost(id))) {
            log.info("Job {} is not or was not run on this node. Forwarding to {}", (Object)id, (Object)jobHostname);
            String forwardUrl = this.buildForwardURL(request, jobHostname);
            try {
                this.restTemplate.execute(forwardUrl, HttpMethod.GET, forwardRequest -> this.copyRequestHeaders(request, forwardRequest), (ResponseExtractor)new ResponseExtractor<Void>(){

                    public Void extractData(ClientHttpResponse forwardResponse) throws IOException {
                        response.setStatus(HttpStatus.OK.value());
                        JobRestController.this.copyResponseHeaders(response, forwardResponse);
                        ByteStreams.copy((InputStream)forwardResponse.getBody(), (OutputStream)response.getOutputStream());
                        return null;
                    }
                }, new Object[0]);
            }
            catch (HttpStatusCodeException e) {
                log.error("Failed getting the remote job output from {}. Error: {}", (Object)forwardUrl, (Object)e.getMessage());
                response.sendError(e.getStatusCode().value(), e.getStatusText());
            }
            catch (Exception e) {
                log.error("Failed getting the remote job output from {}. Error: {}", (Object)forwardUrl, (Object)e.getMessage());
                response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
            }
            return;
        }
        log.info("Job {} is running or was run on this node. Fetching requested resource...", (Object)id);
        String path = ControllerUtils.getRemainingPath(request);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            request.setAttribute(GenieResourceHttpRequestHandler.GENIE_JOB_IS_ROOT_DIRECTORY, (Object)false);
        } else {
            request.setAttribute(GenieResourceHttpRequestHandler.GENIE_JOB_IS_ROOT_DIRECTORY, (Object)true);
        }
        log.debug("PATH = {}", (Object)path);
        request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)(id + "/" + path));
        this.resourceHttpRequestHandler.handleRequest(request, response);
    }

    private String buildForwardURL(HttpServletRequest request, String jobHostname) {
        return this.jobForwardingProperties.getScheme() + "://" + jobHostname + ":" + this.jobForwardingProperties.getPort() + request.getRequestURI();
    }

    private void copyRequestHeaders(HttpServletRequest request, ClientHttpRequest forwardRequest) {
        Cookie[] cookies;
        HttpHeaders headers = forwardRequest.getHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (NAME_HEADER_COOKIE.equals(headerName)) continue;
                String headerValue = request.getHeader(headerName);
                log.debug("Request Header: name = {} value = {}", (Object)headerName, (Object)headerValue);
                headers.add(headerName, headerValue);
            }
        }
        if ((cookies = request.getCookies()) != null && cookies.length > 0) {
            StringBuilder builder = null;
            for (Cookie cookie : request.getCookies()) {
                if (builder == null) {
                    builder = new StringBuilder();
                } else {
                    builder.append(",");
                }
                builder.append(cookie.getName()).append("=").append(cookie.getValue());
            }
            if (builder != null) {
                String cookieValue = builder.toString();
                headers.add(NAME_HEADER_COOKIE, cookieValue);
                log.debug("Request Header: name = {} value = {}", (Object)NAME_HEADER_COOKIE, (Object)cookieValue);
            }
        }
        headers.add("Genie-Forwarded-From", request.getRequestURL().toString());
    }

    private void copyResponseHeaders(HttpServletResponse response, ClientHttpResponse forwardResponse) {
        HttpHeaders headers = forwardResponse.getHeaders();
        for (Map.Entry header : headers.toSingleValueMap().entrySet()) {
            response.setHeader((String)header.getKey(), (String)header.getValue());
        }
    }
}

