/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.netflix.genie.web.controllers.ControllerUtils;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UIController {
    @RequestMapping(value={"/", "/applications/**", "/clusters/**", "/commands/**", "/jobs/**", "/output/**"}, method={RequestMethod.GET})
    public String getIndex(@NotNull HttpServletResponse response, @Nullable Authentication authentication) {
        if (authentication != null) {
            response.addCookie(new Cookie("genie.user", authentication.getName()));
        } else {
            response.addCookie(new Cookie("genie.user", "Genie User"));
        }
        return "index";
    }

    @RequestMapping(value={"/file/{id}/**"}, method={RequestMethod.GET})
    public String getFile(@PathVariable(value="id") String id, HttpServletRequest request) {
        return "forward:/api/v3/jobs/" + id + "/" + ControllerUtils.getRemainingPath(request);
    }
}

