/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security;

import com.netflix.genie.web.security.SecurityConditions;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Conditional(value={SecurityConditions.AnySecurityEnabled.class})
@Configuration
@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Autowired(required=false)
    private Collection<AuthenticationProvider> providers;

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Autowired
    protected void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        if (this.providers != null) {
            for (AuthenticationProvider provider : this.providers) {
                log.debug("Adding authentication provider {} to authentication provider.", (Object)provider.toString());
                auth.authenticationProvider(provider);
            }
        } else {
            log.debug("No providers were found. Configuring in memory authentication to avoid NPE.");
            auth.inMemoryAuthentication();
        }
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/webjars/**", "/images/**", "/css/**", "/templates/**", "/js/**", "/vendor/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().anyRequest()).permitAll();
    }
}

