/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.Validator;

public class PingFederateValidator
implements Validator {
    private final Timer jwtValidationTimer;

    public PingFederateValidator(Registry registry) {
        this.jwtValidationTimer = registry.timer("genie.security.oauth2.pingFederate.jwt.validation.timer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(JwtContext jwtContext) throws MalformedClaimException {
        long start = System.nanoTime();
        try {
            Collection scopes;
            JwtClaims claims = jwtContext.getJwtClaims();
            StringBuilder builder = new StringBuilder();
            String clientId = (String)claims.getClaimValue("client_id", String.class);
            if (clientId == null) {
                builder.append("No client_id field present and is required. ");
            }
            if ((scopes = (Collection)claims.getClaimValue("scope", Collection.class)) == null) {
                builder.append("No scope claim present and is required. ");
            } else if (scopes.isEmpty()) {
                builder.append("No scopes present at least one required. ");
            } else if (!(scopes.iterator().next() instanceof String)) {
                builder.append("Scopes must be of type string. ");
            }
            if (builder.length() == 0) {
                String string = null;
                return string;
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.jwtValidationTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

