/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.saml;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"genie.security.saml.enabled"})
@ConfigurationProperties(prefix="genie.security.saml")
@Component
public class SAMLProperties {
    @NotNull
    private Attributes attributes;
    @NotNull
    private Idp idp;
    @NotNull
    private Keystore keystore;
    private LoadBalancer loadBalancer;
    @NotNull
    private Sp sp;

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Idp getIdp() {
        return this.idp;
    }

    public Keystore getKeystore() {
        return this.keystore;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public Sp getSp() {
        return this.sp;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void setIdp(Idp idp) {
        this.idp = idp;
    }

    public void setKeystore(Keystore keystore) {
        this.keystore = keystore;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public void setSp(Sp sp) {
        this.sp = sp;
    }

    public static class Sp {
        @NotBlank
        private String entityId;
        private String entityBaseURL;

        public String getEntityId() {
            return this.entityId;
        }

        public String getEntityBaseURL() {
            return this.entityBaseURL;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setEntityBaseURL(String entityBaseURL) {
            this.entityBaseURL = entityBaseURL;
        }
    }

    public static class LoadBalancer {
        @NotBlank
        private String scheme = "http";
        @NotBlank
        private String serverName;
        private int serverPort = 80;
        private boolean includeServerPortInRequestURL;
        @NotBlank
        private String contextPath = "/";

        public String getScheme() {
            return this.scheme;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public boolean isIncludeServerPortInRequestURL() {
            return this.includeServerPortInRequestURL;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public void setIncludeServerPortInRequestURL(boolean includeServerPortInRequestURL) {
            this.includeServerPortInRequestURL = includeServerPortInRequestURL;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }
    }

    public static class Keystore {
        @NotBlank
        private String name;
        @NotBlank
        private String password;
        @NotNull
        private DefaultKey defaultKey;

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }

        public DefaultKey getDefaultKey() {
            return this.defaultKey;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setDefaultKey(DefaultKey defaultKey) {
            this.defaultKey = defaultKey;
        }

        public static class DefaultKey {
            @NotBlank
            private String name;
            @NotBlank
            private String password;

            public String getName() {
                return this.name;
            }

            public String getPassword() {
                return this.password;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DefaultKey)) {
                    return false;
                }
                DefaultKey other = (DefaultKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$password = this.getPassword();
                String other$password = other.getPassword();
                return !(this$password == null ? other$password != null : !this$password.equals(other$password));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DefaultKey;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 0 : $name.hashCode());
                String $password = this.getPassword();
                result = result * 59 + ($password == null ? 0 : $password.hashCode());
                return result;
            }

            public String toString() {
                return "SAMLProperties.Keystore.DefaultKey(name=" + this.getName() + ", password=" + this.getPassword() + ")";
            }
        }
    }

    public static class Idp {
        @URL
        private String serviceProviderMetadataURL;

        public String getServiceProviderMetadataURL() {
            return this.serviceProviderMetadataURL;
        }

        public void setServiceProviderMetadataURL(String serviceProviderMetadataURL) {
            this.serviceProviderMetadataURL = serviceProviderMetadataURL;
        }
    }

    public static class Attributes {
        @NotNull
        private User user;
        @NotNull
        private Groups groups;

        public User getUser() {
            return this.user;
        }

        public Groups getGroups() {
            return this.groups;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public void setGroups(Groups groups) {
            this.groups = groups;
        }

        public static class Groups {
            @NotBlank
            private String name;
            @NotBlank
            private String admin;

            public String getName() {
                return this.name;
            }

            public String getAdmin() {
                return this.admin;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setAdmin(String admin) {
                this.admin = admin;
            }
        }

        public static class User {
            @NotBlank
            private String name;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }
}

