/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.saml;

import com.google.common.collect.Lists;
import com.netflix.genie.web.security.saml.SAMLProperties;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"genie.security.saml.enabled"})
@Component
public class SAMLUserDetailsServiceImpl
implements SAMLUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(SAMLUserDetailsServiceImpl.class);
    private static final GrantedAuthority USER = new SimpleGrantedAuthority("ROLE_USER");
    private static final GrantedAuthority ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private final SAMLProperties samlProperties;
    private final Timer loadTimer;

    @Autowired
    public SAMLUserDetailsServiceImpl(@NotNull SAMLProperties samlProperties, @NotNull Registry registry) {
        this.samlProperties = samlProperties;
        this.loadTimer = registry.timer("genie.security.saml.parse.timer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadUserBySAML(SAMLCredential credential) throws UsernameNotFoundException {
        long start = System.nanoTime();
        try {
            if (credential == null) {
                throw new UsernameNotFoundException("No credential entered. Unable to get username.");
            }
            String userAttributeName = this.samlProperties.getAttributes().getUser().getName();
            String userId = credential.getAttributeAsString(userAttributeName);
            if (StringUtils.isBlank((CharSequence)userId)) {
                throw new UsernameNotFoundException("No user id found using attribute: " + userAttributeName);
            }
            ArrayList authorities = Lists.newArrayList((Object[])new GrantedAuthority[]{USER});
            String groupAttributeName = this.samlProperties.getAttributes().getGroups().getName();
            String adminGroup = this.samlProperties.getAttributes().getGroups().getAdmin();
            String[] groups = credential.getAttributeAsStringArray(groupAttributeName);
            if (groups == null) {
                log.warn("No groups found. User will only get ROLE_USER by default.");
            } else if (Arrays.asList(groups).contains(adminGroup)) {
                authorities.add(ADMIN);
            }
            if (log.isDebugEnabled()) {
                log.debug("Attributes:");
                credential.getAttributes().forEach(attribute -> {
                    log.debug("Attribute: {}", (Object)attribute.getName());
                    log.debug("Values: {}", (Object)StringUtils.join((Object[])credential.getAttributeAsStringArray(attribute.getName()), (char)','));
                });
            }
            log.info("{} is logged in with authorities {}", (Object)userId, (Object)authorities);
            User user = new User(userId, "DUMMY", (Collection)authorities);
            return user;
        }
        finally {
            long finished = System.nanoTime();
            this.loadTimer.record(finished - start, TimeUnit.NANOSECONDS);
        }
    }
}

