/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.job;

import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.exceptions.GenieTimeoutException;
import com.netflix.genie.core.events.JobFinishedEvent;
import com.netflix.genie.core.events.JobFinishedReason;
import com.netflix.genie.core.events.KillJobEvent;
import com.netflix.genie.core.util.ProcessChecker;
import com.netflix.genie.core.util.UnixProcessChecker;
import com.netflix.genie.web.properties.JobOutputMaxProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.node.NodeTask;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class JobMonitor
extends NodeTask {
    private static final Logger log = LoggerFactory.getLogger(JobMonitor.class);
    private static final int MAX_ERRORS = 5;
    private final String id;
    private final JobExecution execution;
    private final ProcessChecker processChecker;
    private final ApplicationEventPublisher publisher;
    private final File stdOut;
    private final File stdErr;
    private final long maxStdOutLength;
    private final long maxStdErrLength;
    private final Counter successfulCheckRate;
    private final Counter timeoutRate;
    private final Counter finishedRate;
    private final Counter unsuccessfulCheckRate;
    private final Counter stdOutTooLarge;
    private final Counter stdErrTooLarge;
    private int errorCount;

    public JobMonitor(@Valid JobExecution execution, @NotNull File stdOut, @NotNull File stdErr, @NotNull Executor executor, @NotNull ApplicationEventPublisher publisher, @NotNull Registry registry, @NotNull JobOutputMaxProperties outputMaxProperties) {
        if (!SystemUtils.IS_OS_UNIX) {
            throw new UnsupportedOperationException("Genie doesn't currently support " + SystemUtils.OS_NAME);
        }
        this.errorCount = 0;
        this.id = (String)execution.getId().orElseThrow(IllegalArgumentException::new);
        this.execution = execution;
        this.publisher = publisher;
        int processId = (Integer)execution.getProcessId().orElseThrow(IllegalArgumentException::new);
        Date timeout = (Date)execution.getTimeout().orElseThrow(IllegalArgumentException::new);
        this.processChecker = new UnixProcessChecker(processId, executor, timeout);
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.maxStdOutLength = outputMaxProperties.getStdOut();
        this.maxStdErrLength = outputMaxProperties.getStdErr();
        this.successfulCheckRate = registry.counter("genie.jobs.successfulStatusCheck.rate");
        this.timeoutRate = registry.counter("genie.jobs.timeout.rate");
        this.finishedRate = registry.counter("genie.jobs.finished.rate");
        this.unsuccessfulCheckRate = registry.counter("genie.jobs.unsuccessfulStatusCheck.rate");
        this.stdOutTooLarge = registry.counter("genie.jobs.stdOutTooLarge.rate");
        this.stdErrTooLarge = registry.counter("genie.jobs.stdErrTooLarge.rate");
    }

    @Override
    public void run() {
        block7: {
            try {
                this.processChecker.checkProcess();
                log.debug("Job {} is still running...", (Object)this.id);
                if (this.errorCount != 0) {
                    this.errorCount = 0;
                }
                if (this.stdOut.exists() && this.stdOut.length() > this.maxStdOutLength) {
                    this.publisher.publishEvent((ApplicationEvent)new KillJobEvent(this.id, "Std out length exceeded", (Object)this));
                    this.stdOutTooLarge.increment();
                    return;
                }
                if (this.stdErr.exists() && this.stdErr.length() > this.maxStdErrLength) {
                    this.publisher.publishEvent((ApplicationEvent)new KillJobEvent(this.id, "Std err length exceeded", (Object)this));
                    this.stdErrTooLarge.increment();
                    return;
                }
                this.successfulCheckRate.increment();
            }
            catch (GenieTimeoutException gte) {
                log.info("Job {} has timed out", (Object)this.execution.getId(), (Object)gte);
                this.timeoutRate.increment();
                this.publisher.publishEvent((ApplicationEvent)new KillJobEvent(this.id, "Job exceeded timeout", (Object)this));
            }
            catch (ExecuteException ee) {
                log.info("Job {} has finished", (Object)this.id);
                this.finishedRate.increment();
                this.publisher.publishEvent((ApplicationEvent)new JobFinishedEvent(this.id, JobFinishedReason.PROCESS_COMPLETED, "Process detected to be complete", (Object)this));
            }
            catch (IOException ioe) {
                log.error("Some IOException happened unable to check process status for pid {}", (Object)this.execution.getProcessId(), (Object)ioe);
                ++this.errorCount;
                this.unsuccessfulCheckRate.increment();
                if (this.errorCount <= 5) break block7;
                this.publisher.publishEvent((ApplicationEvent)new KillJobEvent(this.id, "Couldn't check process status 5 consecutive times", (Object)this));
                this.publisher.publishEvent((ApplicationEvent)new JobFinishedEvent(this.id, JobFinishedReason.KILLED, "Couldn't check process status 5 consecutive times", (Object)this));
            }
        }
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_DELAY;
    }

    @Override
    public long getFixedDelay() {
        return (Long)this.execution.getCheckDelay().orElseThrow(IllegalArgumentException::new);
    }
}

