/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.netflix.genie.core.jobs.JobConstants;
import com.netflix.genie.core.services.JobPersistenceService;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.TaskUtils;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.spectator.api.Registry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"genie.tasks.databaseCleanup.enabled"})
@Component
public class DatabaseCleanupTask
extends LeadershipTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseCleanupTask.class);
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final DatabaseCleanupProperties cleanupProperties;
    private final JobPersistenceService jobPersistenceService;
    private final AtomicLong numDeletedJobs;

    @Autowired
    public DatabaseCleanupTask(@NotNull DatabaseCleanupProperties cleanupProperties, @NotNull JobPersistenceService jobPersistenceService, @NotNull Registry registry) {
        this.cleanupProperties = cleanupProperties;
        this.jobPersistenceService = jobPersistenceService;
        this.numDeletedJobs = (AtomicLong)registry.gauge("genie.tasks.databaseCleanup.numDeletedJobs.gauge", (Number)new AtomicLong());
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.TRIGGER;
    }

    @Override
    public Trigger getTrigger() {
        return new CronTrigger(this.cleanupProperties.getExpression(), JobConstants.UTC);
    }

    @Override
    public void run() {
        Calendar cal = TaskUtils.getMidnightUTC();
        TaskUtils.subtractDaysFromDate(cal, this.cleanupProperties.getRetention());
        Date retentionLimit = cal.getTime();
        long numberDeletedJobs = this.jobPersistenceService.deleteAllJobsCreatedBeforeDate(retentionLimit);
        log.info("Deleted {} jobs from before {}", (Object)numberDeletedJobs, (Object)this.dateFormat.format(retentionLimit));
        this.numDeletedJobs.set(numberDeletedJobs);
    }
}

