/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.entities;

import com.netflix.genie.common.dto.ApplicationStatus;
import com.netflix.genie.web.jpa.entities.BaseEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.entities.TagEntity;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="applications")
public class ApplicationEntity
extends BaseEntity {
    private static final long serialVersionUID = -8780722054561507963L;
    @Basic(optional=false)
    @Column(name="status", nullable=false, length=20)
    @Enumerated(value=EnumType.STRING)
    @NotNull(message="No application status entered and is required.")
    private @NotNull(message="No application status entered and is required.") ApplicationStatus status;
    @Basic
    @Column(name="type")
    private String type;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_configs", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_dependencies", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="applications_tags", joinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @ManyToMany(mappedBy="applications", fetch=FetchType.LAZY)
    private Set<CommandEntity> commands = new HashSet<CommandEntity>();

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    void setCommands(@Nullable Set<CommandEntity> commands) {
        this.commands.clear();
        if (commands != null) {
            this.commands.addAll(commands);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public ApplicationStatus getStatus() {
        return this.status;
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public Set<CommandEntity> getCommands() {
        return this.commands;
    }

    public void setStatus(ApplicationStatus status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "ApplicationEntity(super=" + super.toString() + ", status=" + this.getStatus() + ", type=" + this.getType() + ")";
    }
}

