/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.entities;

import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.web.jpa.entities.BaseEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.entities.TagEntity;
import com.netflix.genie.web.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.jpa.entities.projections.ClusterCommandsProjection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="clusters")
public class ClusterEntity
extends BaseEntity
implements ClusterCommandsProjection {
    private static final long serialVersionUID = -5674870110962005872L;
    @Basic(optional=false)
    @Column(name="status", nullable=false, length=20)
    @Enumerated(value=EnumType.STRING)
    @NotNull(message="No cluster status entered and is required.")
    private @NotNull(message="No cluster status entered and is required.") ClusterStatus status;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_configs", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_dependencies", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_tags", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_commands", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)})
    @OrderColumn(name="command_order", nullable=false)
    private List<CommandEntity> commands = new ArrayList<CommandEntity>();

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public void setCommands(@Nullable List<CommandEntity> commands) throws GeniePreconditionException {
        if (commands != null && commands.stream().map(UniqueIdEntity::getUniqueId).distinct().count() != (long)commands.size()) {
            throw new GeniePreconditionException("List of commands to set cannot contain duplicates");
        }
        for (CommandEntity command : this.commands) {
            command.getClusters().remove(this);
        }
        this.commands.clear();
        if (commands != null) {
            this.commands.addAll(commands);
            for (CommandEntity command : this.commands) {
                command.getClusters().add(this);
            }
        }
    }

    public void addCommand(@NotNull CommandEntity command) throws GeniePreconditionException {
        if (this.commands.contains(command)) {
            throw new GeniePreconditionException("A command with id " + command.getUniqueId() + " is already added");
        }
        this.commands.add(command);
        command.getClusters().add(this);
    }

    public void removeCommand(@NotNull CommandEntity command) {
        this.commands.remove(command);
        command.getClusters().remove(this);
    }

    public void removeAllCommands() {
        Lists.newArrayList(this.commands).forEach(this::removeCommand);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public ClusterStatus getStatus() {
        return this.status;
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    @Override
    public List<CommandEntity> getCommands() {
        return this.commands;
    }

    public void setStatus(ClusterStatus status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "ClusterEntity(super=" + super.toString() + ", status=" + this.getStatus() + ")";
    }
}

