/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.repositories;

import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.web.jpa.entities.JobEntity;
import com.netflix.genie.web.jpa.entities.aggregates.UserJobResourcesAggregate;
import com.netflix.genie.web.jpa.entities.projections.AgentHostnameProjection;
import com.netflix.genie.web.jpa.entities.projections.IdProjection;
import com.netflix.genie.web.jpa.entities.projections.JobProjection;
import com.netflix.genie.web.jpa.entities.projections.UniqueIdProjection;
import com.netflix.genie.web.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaJobRepository
extends JpaBaseRepository<JobEntity> {
    public Set<JobProjection> findByAgentHostnameAndStatusIn(String var1, Set<JobStatus> var2);

    public Set<AgentHostnameProjection> findDistinctByStatusInAndV4IsFalse(Set<JobStatus> var1);

    @Modifying
    public Long deleteByIdIn(@NotNull List<Long> var1);

    public Long countJobsByUserAndStatusIn(@NotBlank String var1, @NotEmpty Set<JobStatus> var2);

    public Slice<IdProjection> findByCreatedBefore(@NotNull Instant var1, @NotNull Pageable var2);

    @Query(value="SELECT j.user AS user, COUNT(j) as runningJobsCount, SUM(j.memoryUsed) as usedMemory FROM JobEntity j WHERE j.status = 'RUNNING' AND j.v4 = FALSE GROUP BY j.user")
    public Set<UserJobResourcesAggregate> getUserJobResourcesAggregates();

    @Query(value="SELECT j FROM JobEntity j WHERE j.status IN (:statuses) AND j.v4 = TRUE AND j.uniqueId NOT IN (SELECT c.jobId FROM AgentConnectionEntity c)")
    public Set<UniqueIdProjection> getAgentJobIdsWithNoConnectionInState(@Param(value="statuses") @NotEmpty Set<JobStatus> var1);
}

