/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.netflix.genie.common.dto.ApplicationStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieBadRequestException;
import com.netflix.genie.common.exceptions.GenieConflictException;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.internal.dto.v4.Application;
import com.netflix.genie.common.internal.dto.v4.ApplicationMetadata;
import com.netflix.genie.common.internal.dto.v4.ApplicationRequest;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.common.internal.dto.v4.ExecutionEnvironment;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.common.util.GenieObjectMapper;
import com.netflix.genie.web.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.entities.TagEntity;
import com.netflix.genie.web.jpa.entities.v4.EntityDtoConverters;
import com.netflix.genie.web.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.web.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.jpa.services.JpaBaseService;
import com.netflix.genie.web.jpa.services.JpaFilePersistenceService;
import com.netflix.genie.web.jpa.services.JpaTagPersistenceService;
import com.netflix.genie.web.jpa.specifications.JpaApplicationSpecs;
import com.netflix.genie.web.jpa.specifications.JpaCommandSpecs;
import com.netflix.genie.web.services.ApplicationPersistenceService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieRuntimeException.class, ConstraintViolationException.class})
public class JpaApplicationPersistenceServiceImpl
extends JpaBaseService
implements ApplicationPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaApplicationPersistenceServiceImpl.class);

    public JpaApplicationPersistenceServiceImpl(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        super(tagPersistenceService, filePersistenceService, applicationRepository, clusterRepository, commandRepository);
    }

    @Override
    public String createApplication(@NotNull(message="No application entered to create.") @Valid @NotNull(message="No application entered to create.") @Valid ApplicationRequest applicationRequest) throws GenieException {
        log.debug("Called to create new application with request metadata {}", (Object)applicationRequest);
        ApplicationEntity applicationEntity = this.createApplicationEntity(applicationRequest);
        try {
            this.getApplicationRepository().save(applicationEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieConflictException("An application with id " + applicationEntity.getUniqueId() + " already exists", (Throwable)e);
        }
        return applicationEntity.getUniqueId();
    }

    @Override
    @Transactional(readOnly=true)
    public Application getApplication(@NotBlank(message="No id entered. Unable to get") @NotBlank(message="No id entered. Unable to get") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return EntityDtoConverters.toV4ApplicationDto(this.findApplication(id));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Application> getApplications(@Nullable String name, @Nullable String user, @Nullable Set<ApplicationStatus> statuses, @Nullable Set<String> tags, @Nullable String type, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("Called");
        if (tags != null) {
            tagEntities = this.getTagPersistenceService().getTags(tags);
            if (tagEntities.size() != tags.size()) {
                return new PageImpl(new ArrayList(), page, 0L);
            }
        } else {
            tagEntities = null;
        }
        Page applicationEntities = this.getApplicationRepository().findAll(JpaApplicationSpecs.find(name, user, statuses, tagEntities, type), page);
        return applicationEntities.map(EntityDtoConverters::toV4ApplicationDto);
    }

    @Override
    public void updateApplication(@NotBlank(message="No application id entered. Unable to update.") @NotBlank(message="No application id entered. Unable to update.") String id, @NotNull(message="No application information entered. Unable to update.") @Valid @NotNull(message="No application information entered. Unable to update.") @Valid Application updateApp) throws GenieException {
        if (!this.getApplicationRepository().existsByUniqueId(id)) {
            throw new GenieNotFoundException("No application with id " + id + " exists. Unable to update.");
        }
        String updateId = updateApp.getId();
        if (!id.equals(updateId)) {
            throw new GenieBadRequestException("Application id inconsistent with id passed in.");
        }
        log.debug("Called with app {}", (Object)updateApp);
        this.updateEntityWithDtoContents(this.findApplication(id), updateApp);
    }

    @Override
    public void patchApplication(@NotBlank String id, @NotNull JsonPatch patch) throws GenieException {
        ApplicationEntity applicationEntity = this.findApplication(id);
        try {
            Application appToPatch = EntityDtoConverters.toV4ApplicationDto(applicationEntity);
            log.debug("Will patch application {}. Original state: {}", (Object)id, (Object)appToPatch);
            JsonNode applicationNode = GenieObjectMapper.getMapper().valueToTree((Object)appToPatch);
            JsonNode postPatchNode = patch.apply(applicationNode);
            Application patchedApp = (Application)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, Application.class);
            log.debug("Finished patching application {}. New state: {}", (Object)id, (Object)patchedApp);
            this.updateEntityWithDtoContents(applicationEntity, patchedApp);
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch application {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void deleteAllApplications() throws GenieException {
        log.debug("Called");
        for (ApplicationEntity applicationEntity : this.getApplicationRepository().findAll()) {
            this.checkCommands(applicationEntity);
        }
        this.getApplicationRepository().deleteAll();
    }

    @Override
    public void deleteApplication(@NotBlank(message="No application id entered. Unable to delete.") @NotBlank(message="No application id entered. Unable to delete.") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        ApplicationEntity applicationEntity = this.findApplication(id);
        this.checkCommands(applicationEntity);
        this.getApplicationRepository().delete(applicationEntity);
    }

    @Override
    public void addConfigsToApplication(@NotBlank(message="No application id entered. Unable to add configurations.") @NotBlank(message="No application id entered. Unable to add configurations.") String id, @NotEmpty(message="No configuration files entered.") @NotEmpty(message="No configuration files entered.") Set<String> configs) throws GenieException {
        this.findApplication(id).getConfigs().addAll(this.createAndGetFileEntities(configs));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getConfigsForApplication(@NotBlank(message="No application id entered. Unable to get configs.") @NotBlank(message="No application id entered. Unable to get configs.") String id) throws GenieException {
        return this.findApplication(id).getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateConfigsForApplication(@NotBlank(message="No application id entered. Unable to update configurations.") @NotBlank(message="No application id entered. Unable to update configurations.") String id, @NotNull(message="No configs entered. Unable to update. If you want, use delete API.") @NotNull(message="No configs entered. Unable to update. If you want, use delete API.") Set<String> configs) throws GenieException {
        this.findApplication(id).setConfigs(this.createAndGetFileEntities(configs));
    }

    @Override
    public void removeAllConfigsForApplication(@NotBlank(message="No application id entered. Unable to remove configs.") @NotBlank(message="No application id entered. Unable to remove configs.") String id) throws GenieException {
        this.findApplication(id).getConfigs().clear();
    }

    @Override
    public void removeConfigForApplication(@NotBlank(message="No application id entered. Unable to remove configuration.") @NotBlank(message="No application id entered. Unable to remove configuration.") String id, @NotBlank(message="No config entered. Unable to remove.") @NotBlank(message="No config entered. Unable to remove.") String config) throws GenieException {
        this.getFilePersistenceService().getFile(config).ifPresent(this.findApplication(id).getConfigs()::remove);
    }

    @Override
    public void addDependenciesForApplication(@NotBlank(message="No application id entered. Unable to add dependencies.") @NotBlank(message="No application id entered. Unable to add dependencies.") String id, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> dependencies) throws GenieException {
        this.findApplication(id).getDependencies().addAll(this.createAndGetFileEntities(dependencies));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getDependenciesForApplication(@NotBlank(message="No application id entered. Unable to get dependencies.") @NotBlank(message="No application id entered. Unable to get dependencies.") String id) throws GenieException {
        return this.findApplication(id).getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateDependenciesForApplication(@NotBlank(message="No application id entered. Unable to update dependencies.") @NotBlank(message="No application id entered. Unable to update dependencies.") String id, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> dependencies) throws GenieException {
        this.findApplication(id).setDependencies(this.createAndGetFileEntities(dependencies));
    }

    @Override
    public void removeAllDependenciesForApplication(@NotBlank(message="No application id entered. Unable to remove dependencies.") @NotBlank(message="No application id entered. Unable to remove dependencies.") String id) throws GenieException {
        this.findApplication(id).getDependencies().clear();
    }

    @Override
    public void removeDependencyForApplication(@NotBlank(message="No application id entered. Unable to remove dependency.") @NotBlank(message="No application id entered. Unable to remove dependency.") String id, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String dependency) throws GenieException {
        this.getFilePersistenceService().getFile(dependency).ifPresent(this.findApplication(id).getDependencies()::remove);
    }

    @Override
    public void addTagsForApplication(@NotBlank(message="No application id entered. Unable to add tags.") @NotBlank(message="No application id entered. Unable to add tags.") String id, @NotEmpty(message="No tags entered. Unable to add.") @NotEmpty(message="No tags entered. Unable to add.") Set<String> tags) throws GenieException {
        this.findApplication(id).getTags().addAll(this.createAndGetTagEntities(tags));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getTagsForApplication(@NotBlank(message="No application id entered. Cannot retrieve tags.") @NotBlank(message="No application id entered. Cannot retrieve tags.") String id) throws GenieException {
        return this.findApplication(id).getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet());
    }

    @Override
    public void updateTagsForApplication(@NotBlank(message="No application id entered. Unable to update tags.") @NotBlank(message="No application id entered. Unable to update tags.") String id, @NotNull(message="No tags entered unable to update tags.") @NotNull(message="No tags entered unable to update tags.") Set<String> tags) throws GenieException {
        this.findApplication(id).setTags(this.createAndGetTagEntities(tags));
    }

    @Override
    public void removeAllTagsForApplication(@NotBlank(message="No application id entered. Unable to remove tags.") @NotBlank(message="No application id entered. Unable to remove tags.") String id) throws GenieException {
        this.findApplication(id).getTags().clear();
    }

    @Override
    public void removeTagForApplication(@NotBlank(message="No application id entered. Unable to remove tag.") @NotBlank(message="No application id entered. Unable to remove tag.") String id, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String tag) throws GenieException {
        this.getTagPersistenceService().getTag(tag).ifPresent(this.findApplication(id).getTags()::remove);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Command> getCommandsForApplication(@NotBlank(message="No application id entered. Unable to get commands.") @NotBlank(message="No application id entered. Unable to get commands.") String id, @Nullable Set<CommandStatus> statuses) throws GenieException {
        if (!this.getApplicationRepository().existsByUniqueId(id)) {
            throw new GenieNotFoundException("No application with id " + id + " exists.");
        }
        return this.getCommandRepository().findAll(JpaCommandSpecs.findCommandsForApplication(id, statuses)).stream().map(EntityDtoConverters::toV4CommandDto).collect(Collectors.toSet());
    }

    private ApplicationEntity findApplication(String id) throws GenieNotFoundException {
        return (ApplicationEntity)this.getApplicationRepository().findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No application with id " + id));
    }

    private ApplicationEntity createApplicationEntity(ApplicationRequest request) {
        ExecutionEnvironment resources = request.getResources();
        ApplicationMetadata metadata = request.getMetadata();
        ApplicationEntity entity = new ApplicationEntity();
        this.setUniqueId(entity, request.getRequestedId().orElse(null));
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityApplicationMetadata(entity, metadata);
        return entity;
    }

    private void updateEntityWithDtoContents(ApplicationEntity entity, Application dto) {
        ExecutionEnvironment resources = dto.getResources();
        ApplicationMetadata metadata = dto.getMetadata();
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityApplicationMetadata(entity, metadata);
    }

    private void setEntityApplicationMetadata(ApplicationEntity entity, ApplicationMetadata metadata) {
        entity.setName(metadata.getName());
        entity.setUser(metadata.getUser());
        entity.setVersion(metadata.getVersion());
        entity.setDescription(metadata.getDescription().orElse(null));
        entity.setStatus(metadata.getStatus());
        entity.setType(metadata.getType().orElse(null));
        EntityDtoConverters.setJsonField(metadata.getMetadata().orElse(null), entity::setMetadata);
    }

    private void checkCommands(ApplicationEntity applicationEntity) throws GeniePreconditionException {
        Set<CommandEntity> commands = applicationEntity.getCommands();
        if (commands != null && !commands.isEmpty()) {
            throw new GeniePreconditionException("Unable to delete app " + applicationEntity.getId() + " as it is attached to " + commands.size() + " commands still.");
        }
    }
}

