/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;

public final class H2Utils {
    static final String V3_COMMAND_EXECUTABLE_QUERY = "SELECT `id`, `executable` FROM `commands`;";
    static final String V4_COMMAND_ARGUMENT_SQL = "INSERT INTO `command_executable_arguments` VALUES(?,?,?);";
    static final int V3_COMMAND_ID_INDEX = 1;
    static final int V3_COMMAND_EXECUTABLE_INDEX = 2;
    static final int V4_COMMAND_ID_INDEX = 1;
    static final int V4_COMMAND_ARGUMENT_INDEX = 2;
    static final int V4_COMMAND_ARGUMENT_ORDER_INDEX = 3;

    private H2Utils() {
    }

    public static void splitV3CommandExecutableForV4(Connection con) throws Exception {
        try (PreparedStatement commandsQuery = con.prepareStatement(V3_COMMAND_EXECUTABLE_QUERY);
             PreparedStatement insertCommandArgument = con.prepareStatement(V4_COMMAND_ARGUMENT_SQL);
             ResultSet rs = commandsQuery.executeQuery();){
            while (rs.next()) {
                long commandId = rs.getLong(1);
                String executable = rs.getString(2);
                String[] arguments = StringUtils.splitByWholeSeparator((String)executable, null);
                if (arguments.length <= 0) continue;
                insertCommandArgument.setLong(1, commandId);
                for (int i = 0; i < arguments.length; ++i) {
                    insertCommandArgument.setString(2, arguments[i]);
                    insertCommandArgument.setInt(3, i);
                    insertCommandArgument.executeUpdate();
                }
            }
        }
    }
}

