/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.entities;

import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.web.data.entities.ApplicationEntity;
import com.netflix.genie.web.data.entities.BaseEntity;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.entities.UniqueIdEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="commands")
public class CommandEntity
extends BaseEntity {
    private static final long serialVersionUID = -8058995173025433517L;
    @Basic(optional=false)
    @Column(name="status", nullable=false, length=20)
    @Enumerated(value=EnumType.STRING)
    @NotNull(message="No command status entered and is required.")
    private @NotNull(message="No command status entered and is required.") CommandStatus status;
    @ElementCollection
    @CollectionTable(name="command_executable_arguments", joinColumns={@JoinColumn(name="command_id", nullable=false)})
    @Column(name="argument", length=1024, nullable=false)
    @OrderColumn(name="argument_order", nullable=false)
    @NotEmpty(message="No executable arguments entered. At least one is required.")
    private @NotEmpty(message="No executable arguments entered. At least one is required.") List<@NotBlank @Size(max=1024) String> executable = new ArrayList<String>();
    @Basic(optional=false)
    @Column(name="check_delay", nullable=false)
    @Min(value=1L)
    private @Min(value=1L) long checkDelay = 10000L;
    @Basic
    @Column(name="memory")
    @Min(value=1L)
    private @Min(value=1L) Integer memory;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_configs", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_dependencies", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_tags", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_applications", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)})
    @OrderColumn(name="application_order", nullable=false)
    private List<ApplicationEntity> applications = new ArrayList<ApplicationEntity>();
    @ManyToMany(mappedBy="commands", fetch=FetchType.LAZY)
    private Set<ClusterEntity> clusters = new HashSet<ClusterEntity>();

    public void setExecutable(@NotEmpty List<@NotBlank @Size(max=1024) String> executable) {
        this.executable.clear();
        this.executable.addAll(executable);
    }

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public Optional<Integer> getMemory() {
        return Optional.ofNullable(this.memory);
    }

    public void setApplications(@Nullable List<ApplicationEntity> applications) throws GeniePreconditionException {
        if (applications != null && applications.stream().map(UniqueIdEntity::getUniqueId).distinct().count() != (long)applications.size()) {
            throw new GeniePreconditionException("List of applications to set cannot contain duplicates");
        }
        for (ApplicationEntity application : this.applications) {
            application.getCommands().remove(this);
        }
        this.applications.clear();
        if (applications != null) {
            this.applications.addAll(applications);
            for (ApplicationEntity application : this.applications) {
                application.getCommands().add(this);
            }
        }
    }

    public void addApplication(@NotNull ApplicationEntity application) throws GeniePreconditionException {
        if (this.applications.contains(application)) {
            throw new GeniePreconditionException("An application with id " + application.getUniqueId() + " is already added");
        }
        this.applications.add(application);
        application.getCommands().add(this);
    }

    public void removeApplication(@NotNull ApplicationEntity application) {
        this.applications.remove(application);
        application.getCommands().remove(this);
    }

    protected void setClusters(@Nullable Set<ClusterEntity> clusters) {
        this.clusters.clear();
        if (clusters != null) {
            this.clusters.addAll(clusters);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public CommandStatus getStatus() {
        return this.status;
    }

    public List<String> getExecutable() {
        return this.executable;
    }

    public long getCheckDelay() {
        return this.checkDelay;
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public List<ApplicationEntity> getApplications() {
        return this.applications;
    }

    public Set<ClusterEntity> getClusters() {
        return this.clusters;
    }

    public void setStatus(CommandStatus status) {
        this.status = status;
    }

    public void setCheckDelay(long checkDelay) {
        this.checkDelay = checkDelay;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    @Override
    public String toString() {
        return "CommandEntity(super=" + super.toString() + ", status=" + this.getStatus() + ", executable=" + this.getExecutable() + ", checkDelay=" + this.getCheckDelay() + ", memory=" + this.getMemory() + ")";
    }
}

