/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs;

import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.Application;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.web.services.JobSubmitterService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLauncher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobLauncher.class);
    static final String JOB_SUBMIT_TIMER_NAME = "genie.jobs.submit.timer";
    private final JobSubmitterService jobSubmitterService;
    private final JobRequest jobRequest;
    private final Cluster cluster;
    private final Command command;
    private final List<Application> applications;
    private final int memory;
    private final MeterRegistry registry;

    public JobLauncher(@NotNull JobSubmitterService jobSubmitterService, @NotNull JobRequest jobRequest, @NotNull Cluster cluster, @NotNull Command command, @NotNull List<Application> applications, @Min(value=1L) @Min(value=1L) int memory, @NotNull MeterRegistry registry) {
        this.jobSubmitterService = jobSubmitterService;
        this.jobRequest = jobRequest;
        this.cluster = cluster;
        this.command = command;
        this.applications = applications;
        this.memory = memory;
        this.registry = registry;
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            this.jobSubmitterService.submitJob(this.jobRequest, this.cluster, this.command, this.applications, this.memory);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (GenieException e) {
            log.error("Unable to submit job due to exception: {}", (Object)e.getMessage(), (Object)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(JOB_SUBMIT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

