/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.internal.dto.v4.AgentClientMetadata;
import com.netflix.genie.common.internal.dto.v4.JobRequest;
import com.netflix.genie.common.internal.dto.v4.JobRequestMetadata;
import com.netflix.genie.common.internal.dto.v4.JobSpecification;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieAgentRejectedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobSpecificationNotFoundException;
import com.netflix.genie.web.services.AgentFilterService;
import com.netflix.genie.web.services.AgentJobService;
import com.netflix.genie.web.services.JobPersistenceService;
import com.netflix.genie.web.services.JobSpecificationService;
import com.netflix.genie.web.util.InspectionReport;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
@Transactional
public class AgentJobServiceImpl
implements AgentJobService {
    private static final String AGENT_JOB_SERVICE_METRIC_PREFIX = "genie.services.agentJob.";
    private static final String HANDSHAKE_COUNTER_METRIC_NAME = "genie.services.agentJob.handshake.counter";
    private static final String AGENT_VERSION_METRIC_TAG_NAME = "agentVersion";
    private static final String AGENT_HOST_METRIC_TAG_NAME = "agentHost";
    private static final String HANDSHAKE_DECISION_METRIC_TAG_NAME = "handshakeDecision";
    private final JobPersistenceService jobPersistenceService;
    private final JobSpecificationService jobSpecificationService;
    private final AgentFilterService agentFilterService;
    private final MeterRegistry meterRegistry;

    public AgentJobServiceImpl(JobPersistenceService jobPersistenceService, JobSpecificationService jobSpecificationService, AgentFilterService agentFilterService, MeterRegistry meterRegistry) {
        this.jobPersistenceService = jobPersistenceService;
        this.jobSpecificationService = jobSpecificationService;
        this.agentFilterService = agentFilterService;
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void handshake(@Valid AgentClientMetadata agentClientMetadata) throws GenieAgentRejectedException {
        InspectionReport report;
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{Tag.of((String)AGENT_VERSION_METRIC_TAG_NAME, (String)agentClientMetadata.getVersion().orElse("null")), Tag.of((String)AGENT_HOST_METRIC_TAG_NAME, (String)agentClientMetadata.getHostname().orElse("null"))});
        try {
            report = this.agentFilterService.inspectAgentMetadata(agentClientMetadata);
        }
        catch (Exception e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            this.meterRegistry.counter(HANDSHAKE_COUNTER_METRIC_NAME, (Iterable)tags).increment();
            throw e;
        }
        MetricsUtils.addSuccessTags(tags);
        tags.add(Tag.of((String)HANDSHAKE_DECISION_METRIC_TAG_NAME, (String)report.getDecision().name()));
        this.meterRegistry.counter(HANDSHAKE_COUNTER_METRIC_NAME, (Iterable)tags).increment();
        if (report.getDecision() == InspectionReport.Decision.REJECT) {
            throw new GenieAgentRejectedException("Agent rejected: " + report.getMessage());
        }
    }

    @Override
    public String reserveJobId(@Valid JobRequest jobRequest, @Valid AgentClientMetadata agentClientMetadata) {
        JobRequestMetadata jobRequestMetadata = new JobRequestMetadata(null, agentClientMetadata, 0, 0L);
        return this.jobPersistenceService.saveJobRequest(jobRequest, jobRequestMetadata);
    }

    @Override
    public JobSpecification resolveJobSpecification(@NotBlank String id) {
        JobRequest jobRequest = this.jobPersistenceService.getJobRequest(id).orElseThrow(() -> new GenieJobNotFoundException("No job request exists for job id " + id));
        JobSpecification jobSpecification = this.jobSpecificationService.resolveJobSpecification(id, jobRequest);
        this.jobPersistenceService.saveJobSpecification(id, jobSpecification);
        return jobSpecification;
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification getJobSpecification(@NotBlank String id) {
        return this.jobPersistenceService.getJobSpecification(id).orElseThrow(() -> new GenieJobSpecificationNotFoundException("No job specification exists for job with id " + id));
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification dryRunJobSpecificationResolution(@Valid JobRequest jobRequest) {
        return this.jobSpecificationService.resolveJobSpecification(jobRequest.getRequestedId().orElse(UUID.randomUUID().toString()), jobRequest);
    }

    @Override
    public void claimJob(@NotBlank String id, @Valid AgentClientMetadata agentClientMetadata) {
        this.jobPersistenceService.claimJob(id, agentClientMetadata);
    }

    @Override
    public void updateJobStatus(@NotBlank String id, JobStatus currentStatus, JobStatus newStatus, @Nullable String newStatusMessage) {
        this.jobPersistenceService.updateJobStatus(id, currentStatus, newStatus, newStatusMessage);
    }
}

