/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.services.AgentConnectionPersistenceService;
import com.netflix.genie.web.services.AgentMetricsService;
import io.micrometer.core.instrument.MeterRegistry;

public class AgentMetricsServiceImpl
implements AgentMetricsService {
    static final String CONNECTED_GUAGE_METRIC_NAME = "genie.agents.connected.gauge";
    private final GenieHostInfo genieHostInfo;
    private final AgentConnectionPersistenceService agentConnectionPersistenceService;

    public AgentMetricsServiceImpl(GenieHostInfo genieHostInfo, AgentConnectionPersistenceService agentConnectionPersistenceService, MeterRegistry registry) {
        this.genieHostInfo = genieHostInfo;
        this.agentConnectionPersistenceService = agentConnectionPersistenceService;
        registry.gauge(CONNECTED_GUAGE_METRIC_NAME, (Object)this, AgentMetricsServiceImpl::getNumConnectedAgents);
    }

    @Override
    public long getNumConnectedAgents() {
        return this.agentConnectionPersistenceService.getNumAgentConnectionsOnServer(this.genieHostInfo.getHostname());
    }
}

