/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.web.properties.ScriptLoadBalancerProperties;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.RandomizedClusterLoadBalancerImpl;
import com.netflix.genie.web.services.loadbalancers.script.ScriptLoadBalancer;
import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={ScriptLoadBalancerProperties.class})
public class GenieClusterLoadBalancerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GenieClusterLoadBalancerAutoConfiguration.class);
    public static final int SCRIPT_LOAD_BALANCER_PRECEDENCE = 2147483597;

    @Bean
    @Order(value=2147483597)
    @ConditionalOnProperty(value={"genie.jobs.clusters.load-balancers.script.enabled"}, havingValue="true")
    public ScriptLoadBalancer scriptLoadBalancer(@Qualifier(value="genieAsyncTaskExecutor") AsyncTaskExecutor asyncTaskExecutor, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fileTransferService, Environment environment, ObjectMapper mapper, MeterRegistry registry) {
        log.info("Script load balancing is enabled. Creating a ScriptLoadBalancer.");
        return new ScriptLoadBalancer(asyncTaskExecutor, taskScheduler, fileTransferService, environment, mapper, registry);
    }

    @Bean
    @Order
    public RandomizedClusterLoadBalancerImpl randomizedClusterLoadBalancer() {
        return new RandomizedClusterLoadBalancerImpl();
    }
}

