/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.web.health.GenieAgentHealthIndicator;
import com.netflix.genie.web.health.GenieMemoryHealthIndicator;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.AgentMetricsService;
import com.netflix.genie.web.services.JobMetricsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GenieHealthAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GenieMemoryHealthIndicator.class})
    public GenieMemoryHealthIndicator genieMemoryHealthIndicator(JobMetricsService jobMetricsService, JobsProperties jobsProperties) {
        return new GenieMemoryHealthIndicator(jobMetricsService, jobsProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={GenieAgentHealthIndicator.class})
    public GenieAgentHealthIndicator genieAgentHealthIndicator(AgentMetricsService agentMetricsService) {
        return new GenieAgentHealthIndicator(agentMetricsService);
    }
}

