/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.web.configs.GenieTasksAutoConfiguration;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.properties.LeadershipProperties;
import com.netflix.genie.web.properties.ZookeeperLeadershipProperties;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.genie.web.tasks.leader.LeadershipTasksCoordinator;
import com.netflix.genie.web.tasks.leader.LocalLeader;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.zookeeper.config.LeaderInitiatorFactoryBean;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={LeadershipProperties.class, ZookeeperLeadershipProperties.class})
@AutoConfigureAfter(value={GenieTasksAutoConfiguration.class, ZookeeperAutoConfiguration.class})
public class GenieLeadershipAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={LeadershipTask.class})
    public LeadershipTasksCoordinator leadershipTasksCoordinator(TaskScheduler taskScheduler, Collection<LeadershipTask> tasks) {
        return new LeadershipTasksCoordinator(taskScheduler, tasks);
    }

    @Bean
    @ConditionalOnBean(value={CuratorFramework.class})
    public LeaderInitiatorFactoryBean leaderInitiatorFactory(CuratorFramework client, ZookeeperLeadershipProperties zookeeperLeadershipProperties) {
        LeaderInitiatorFactoryBean factoryBean = new LeaderInitiatorFactoryBean();
        factoryBean.setClient(client);
        factoryBean.setPath(zookeeperLeadershipProperties.getPath());
        factoryBean.setRole("cluster");
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={CuratorFramework.class})
    public LocalLeader localLeader(GenieEventBus genieEventBus, LeadershipProperties leadershipProperties) {
        return new LocalLeader(genieEventBus, leadershipProperties.isEnabled());
    }
}

