/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.netflix.genie.common.internal.aws.s3.S3ClientFactory;
import com.netflix.genie.web.properties.AwsCredentialsProperties;
import com.netflix.genie.web.properties.RetryProperties;
import com.netflix.genie.web.properties.S3FileTransferProperties;
import com.netflix.genie.web.services.impl.S3FileTransferImpl;
import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnBean(value={AWSCredentialsProvider.class})
@AutoConfigureAfter(value={ContextCredentialsAutoConfiguration.class})
@EnableConfigurationProperties(value={AwsCredentialsProperties.class, AwsCredentialsProperties.SpringCloudAwsRegionProperties.class, RetryProperties.class, S3FileTransferProperties.class})
public class GenieAwsS3AutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GenieAwsS3AutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"genieAwsClientConfiguration"}, value={ClientConfiguration.class})
    public ClientConfiguration genieAwsClientConfiguration(RetryProperties retryProperties) {
        return new ClientConfiguration().withRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)retryProperties.getS3().getNoOfRetries()));
    }

    @Bean(name={"file.system.s3", "file.system.s3n", "file.system.s3a"})
    @Order(value=1)
    public S3FileTransferImpl s3FileTransferImpl(S3ClientFactory s3ClientFactory, MeterRegistry registry, S3FileTransferProperties s3FileTransferProperties) {
        return new S3FileTransferImpl(s3ClientFactory, registry, s3FileTransferProperties);
    }
}

