/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.repositories.jpa.specifications;

import com.netflix.genie.common.dto.ApplicationStatus;
import com.netflix.genie.web.data.entities.ApplicationEntity;
import com.netflix.genie.web.data.entities.ApplicationEntity_;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaSpecificationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public final class JpaApplicationSpecs {
    private JpaApplicationSpecs() {
    }

    public static Specification<ApplicationEntity> find(@Nullable String name, @Nullable String user, @Nullable Set<ApplicationStatus> statuses, @Nullable Set<TagEntity> tags, @Nullable String type) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.name), name));
            }
            if (StringUtils.isNotBlank((CharSequence)user)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.user), user));
            }
            if (statuses != null && !statuses.isEmpty()) {
                predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(ApplicationEntity_.status), status)).toArray(Predicate[]::new)));
            }
            if (tags != null && !tags.isEmpty()) {
                SetJoin tagEntityJoin = root.join(ApplicationEntity_.tags);
                predicates.add(tagEntityJoin.in((Collection)tags));
                cq.groupBy(new Expression[]{root.get(ApplicationEntity_.id)});
                cq.having((Expression)cb.equal(cb.count((Expression)root.get(ApplicationEntity_.id)), (Object)tags.size()));
            }
            if (StringUtils.isNotBlank((CharSequence)type)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.type), type));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }
}

