/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.repositories.jpa.specifications;

import com.netflix.genie.web.data.entities.TagEntity;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public final class JpaSpecificationUtils {
    static final String PERCENT = "%";
    static final String TAG_DELIMITER = "|";

    private JpaSpecificationUtils() {
    }

    public static String createTagSearchString(Set<TagEntity> tags) {
        return TAG_DELIMITER + tags.stream().map(TagEntity::getTag).sorted(String.CASE_INSENSITIVE_ORDER).reduce((one, two) -> one + TAG_DELIMITER + TAG_DELIMITER + two).orElse("") + TAG_DELIMITER;
    }

    static Predicate getStringLikeOrEqualPredicate(@NotNull CriteriaBuilder cb, @NotNull Expression<String> expression, @NotNull String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)PERCENT)) {
            return cb.like(expression, value);
        }
        return cb.equal(expression, (Object)value);
    }

    static String getTagLikeString(@NotNull Set<String> tags) {
        StringBuilder builder = new StringBuilder();
        tags.stream().filter(StringUtils::isNotBlank).sorted(String.CASE_INSENSITIVE_ORDER).forEach(tag -> builder.append(PERCENT).append(TAG_DELIMITER).append((String)tag).append(TAG_DELIMITER));
        return builder.append(PERCENT).toString();
    }
}

