/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.JobRestController;
import com.netflix.genie.web.hateoas.resources.JobMetadataResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class JobMetadataResourceAssembler
implements ResourceAssembler<JobMetadata, JobMetadataResource> {
    public JobMetadataResource toResource(JobMetadata jobMetadata) {
        String id = (String)jobMetadata.getId().orElseThrow(IllegalArgumentException::new);
        JobMetadataResource jobMetadataResource = new JobMetadataResource(jobMetadata);
        try {
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id))).withSelfRel());
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id))).withRel("job"));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id))).withRel("request"));
            String output = "output";
            jobMetadataResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)"output")).withRel("output"));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel("status"));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id))).withRel("execution"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobMetadataResource;
    }
}

