/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.active-limit")
@Validated
public class JobsActiveLimitProperties
implements EnvironmentAware {
    public static final String PROPERTY_PREFIX = "genie.jobs.active-limit";
    public static final String ENABLED_PROPERTY = "genie.jobs.active-limit.enabled";
    public static final String USER_LIMIT_OVERRIDE_PROPERTY_PREFIX = "genie.jobs.active-limit.overrides.";
    public static final boolean DEFAULT_ENABLED = false;
    public static final int DEFAULT_COUNT = 100;
    private boolean enabled = false;
    @Min(value=1L)
    private @Min(value=1L) int count = 100;
    private AtomicReference<Environment> environment = new AtomicReference();

    public int getUserLimit(String user) {
        Environment env = this.environment.get();
        if (env != null) {
            return (Integer)env.getProperty(USER_LIMIT_OVERRIDE_PROPERTY_PREFIX + user, Integer.class, (Object)this.count);
        }
        return this.count;
    }

    public void setEnvironment(Environment environment) {
        this.environment.set(environment);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCount() {
        return this.count;
    }

    public AtomicReference<Environment> getEnvironment() {
        return this.environment;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

