/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.netflix.genie.web.properties.ExponentialBackOffTriggerProperties;
import com.netflix.genie.web.properties.JobsActiveLimitProperties;
import com.netflix.genie.web.properties.JobsCleanupProperties;
import com.netflix.genie.web.properties.JobsForwardingProperties;
import com.netflix.genie.web.properties.JobsLocationsProperties;
import com.netflix.genie.web.properties.JobsMaxProperties;
import com.netflix.genie.web.properties.JobsMemoryProperties;
import com.netflix.genie.web.properties.JobsUsersProperties;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@Validated
public class JobsProperties {
    @Valid
    private JobsCleanupProperties cleanup;
    @Valid
    private JobsForwardingProperties forwarding;
    @Valid
    private JobsLocationsProperties locations;
    @Valid
    private JobsMaxProperties max;
    @Valid
    private JobsMemoryProperties memory;
    @Valid
    private JobsUsersProperties users;
    @Valid
    private ExponentialBackOffTriggerProperties completionCheckBackOff;
    @Valid
    private JobsActiveLimitProperties activeLimit;

    public JobsProperties(@Valid JobsCleanupProperties cleanup, @Valid JobsForwardingProperties forwarding, @Valid JobsLocationsProperties locations, @Valid JobsMaxProperties max, @Valid JobsMemoryProperties memory, @Valid JobsUsersProperties users, @Valid ExponentialBackOffTriggerProperties completionCheckBackOff, @Valid JobsActiveLimitProperties activeLimit) {
        this.cleanup = cleanup;
        this.forwarding = forwarding;
        this.locations = locations;
        this.max = max;
        this.memory = memory;
        this.users = users;
        this.completionCheckBackOff = completionCheckBackOff;
        this.activeLimit = activeLimit;
    }

    public static JobsProperties getJobsPropertiesDefaults() {
        return new JobsProperties(new JobsCleanupProperties(), new JobsForwardingProperties(), new JobsLocationsProperties(), new JobsMaxProperties(), new JobsMemoryProperties(), new JobsUsersProperties(), new ExponentialBackOffTriggerProperties(), new JobsActiveLimitProperties());
    }

    public JobsCleanupProperties getCleanup() {
        return this.cleanup;
    }

    public JobsForwardingProperties getForwarding() {
        return this.forwarding;
    }

    public JobsLocationsProperties getLocations() {
        return this.locations;
    }

    public JobsMaxProperties getMax() {
        return this.max;
    }

    public JobsMemoryProperties getMemory() {
        return this.memory;
    }

    public JobsUsersProperties getUsers() {
        return this.users;
    }

    public ExponentialBackOffTriggerProperties getCompletionCheckBackOff() {
        return this.completionCheckBackOff;
    }

    public JobsActiveLimitProperties getActiveLimit() {
        return this.activeLimit;
    }

    public void setCleanup(JobsCleanupProperties cleanup) {
        this.cleanup = cleanup;
    }

    public void setForwarding(JobsForwardingProperties forwarding) {
        this.forwarding = forwarding;
    }

    public void setLocations(JobsLocationsProperties locations) {
        this.locations = locations;
    }

    public void setMax(JobsMaxProperties max) {
        this.max = max;
    }

    public void setMemory(JobsMemoryProperties memory) {
        this.memory = memory;
    }

    public void setUsers(JobsUsersProperties users) {
        this.users = users;
    }

    public void setCompletionCheckBackOff(ExponentialBackOffTriggerProperties completionCheckBackOff) {
        this.completionCheckBackOff = completionCheckBackOff;
    }

    public void setActiveLimit(JobsActiveLimitProperties activeLimit) {
        this.activeLimit = activeLimit;
    }
}

