/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.resources.agent;

import com.netflix.genie.web.services.AgentFileStreamService;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AgentFileProtocolResolver
implements ProtocolResolver {
    private static final Logger log = LoggerFactory.getLogger(AgentFileProtocolResolver.class);
    public static final String URI_SCHEME = "agent";
    private static final Path ROOT_PATH = Paths.get(".", new String[0]).toAbsolutePath().getRoot();
    private final AgentFileStreamService agentFileStreamService;

    public AgentFileProtocolResolver(AgentFileStreamService agentFileStreamService) {
        this.agentFileStreamService = agentFileStreamService;
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        URI uri;
        log.debug("Attempting to resolve if {} is an Agent file resource or not", (Object)location);
        try {
            uri = URI.create(location);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.debug("{} is not a valid Agent resource (Error message: {}).", (Object)location, (Object)e.getMessage());
            return null;
        }
        if (URI_SCHEME.equals(uri.getScheme())) {
            log.info("{} is a valid agent resource.", (Object)location);
            String jobId = uri.getHost();
            Path relativePath = ROOT_PATH.relativize(Paths.get(uri.getPath(), new String[0])).normalize();
            AgentFileStreamService.AgentFileResource resourceOrNull = this.agentFileStreamService.getResource(jobId, relativePath, uri).orElse(null);
            if (resourceOrNull != null) {
                log.info("Returning resource: {}", (Object)resourceOrNull.getDescription());
                return resourceOrNull;
            }
        }
        return null;
    }
}

