/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.rpc.grpc.services.impl.v4;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.proto.PingRequest;
import com.netflix.genie.proto.PingServiceGrpc;
import com.netflix.genie.proto.PongResponse;
import com.netflix.genie.web.rpc.grpc.interceptors.SimpleLoggingInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import net.devh.springboot.autoconfigure.grpc.server.GrpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"genie.grpc.server.enabled"}, havingValue="true")
@GrpcService(value=PingServiceGrpc.class, interceptors={SimpleLoggingInterceptor.class})
public class GRpcPingServiceImpl
extends PingServiceGrpc.PingServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRpcPingServiceImpl.class);
    private final String hostName;

    GRpcPingServiceImpl(GenieHostInfo genieHostInfo) {
        this.hostName = genieHostInfo.getHostname();
    }

    public void ping(PingRequest request, StreamObserver<PongResponse> responseObserver) {
        PongResponse response = PongResponse.newBuilder().setRequestId(request.getRequestId()).setTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).putServerMetadata("hostName", this.hostName).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Received ping with id: '%s' from client: '%s' and timestamp: '%s'. ", request.getRequestId(), request.getSourceName(), Timestamps.toString((Timestamp)request.getTimestamp())));
        sb.append("Client metadata: [ ");
        for (Map.Entry clientMetadataEntry : request.getClientMetadataMap().entrySet()) {
            sb.append("{").append((String)clientMetadataEntry.getKey()).append(" : ").append((String)clientMetadataEntry.getValue()).append("}, ");
        }
        sb.append("]");
        log.info(sb.toString());
    }

    static final class ServerMetadataKeys {
        static final String SERVER_NAME = "hostName";

        ServerMetadataKeys() {
        }
    }
}

