/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.internal.dto.v4.Application;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.common.internal.dto.v4.Criterion;
import com.netflix.genie.common.internal.dto.v4.ExecutionEnvironment;
import com.netflix.genie.common.internal.dto.v4.JobMetadata;
import com.netflix.genie.common.internal.dto.v4.JobSpecification;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.ApplicationPersistenceService;
import com.netflix.genie.web.services.ClusterLoadBalancer;
import com.netflix.genie.web.services.ClusterPersistenceService;
import com.netflix.genie.web.services.CommandPersistenceService;
import com.netflix.genie.web.services.JobSpecificationService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.validation.annotation.Validated;

@Validated
@ParametersAreNonnullByDefault
public class JobSpecificationServiceImpl
implements JobSpecificationService {
    private static final Logger log = LoggerFactory.getLogger(JobSpecificationServiceImpl.class);
    private static final String RESOLVE_JOB_SPECIFICATION_TIMER = "genie.services.specification.resolve.timer";
    private static final String CLUSTER_COMMAND_QUERY_TIMER_NAME = "genie.services.specification.clusterCommandQuery.timer";
    private static final String SELECT_CLUSTER_TIMER_NAME = "genie.services.specification.selectCluster.timer";
    private static final String SELECT_COMMAND_TIMER_NAME = "genie.services.specification.selectCommand.timer";
    private static final String SELECT_APPLICATIONS_TIMER_NAME = "genie.services.specification.selectApplications.timer";
    private static final String SELECT_LOAD_BALANCER_COUNTER_NAME = "genie.services.specification.loadBalancer.counter";
    private static final File DEFAULT_JOB_DIRECTORY = new File("/tmp/genie/jobs");
    private static final String NO_ID_FOUND = "No id found";
    private static final String LOAD_BALANCER_STATUS_SUCCESS = "success";
    private static final String LOAD_BALANCER_STATUS_NO_PREFERENCE = "no preference";
    private static final String LOAD_BALANCER_STATUS_EXCEPTION = "exception";
    private static final String LOAD_BALANCER_STATUS_INVALID = "invalid";
    private final ApplicationPersistenceService applicationPersistenceService;
    private final ClusterPersistenceService clusterPersistenceService;
    private final CommandPersistenceService commandPersistenceService;
    private final List<ClusterLoadBalancer> clusterLoadBalancers;
    private final MeterRegistry registry;
    private final int defaultMemory;
    private final Counter noClusterSelectedCounter;
    private final Counter noClusterFoundCounter;

    public JobSpecificationServiceImpl(ApplicationPersistenceService applicationPersistenceService, ClusterPersistenceService clusterPersistenceService, CommandPersistenceService commandPersistenceService, @NotEmpty List<ClusterLoadBalancer> clusterLoadBalancers, MeterRegistry registry, JobsProperties jobsProperties) {
        this.applicationPersistenceService = applicationPersistenceService;
        this.clusterPersistenceService = clusterPersistenceService;
        this.commandPersistenceService = commandPersistenceService;
        this.clusterLoadBalancers = clusterLoadBalancers;
        this.defaultMemory = jobsProperties.getMemory().getDefaultJobMemory();
        this.registry = registry;
        this.noClusterSelectedCounter = this.registry.counter("genie.services.specification.selectCluster.noneSelected.counter", new String[0]);
        this.noClusterFoundCounter = this.registry.counter("genie.services.specification.selectCluster.noneFound.counter", new String[0]);
    }

    @Override
    public JobSpecification resolveJobSpecification(String id, @Valid com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest) {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            log.info("Received request to resolve a job specification for job id {} and parameters {}", (Object)id, (Object)jobRequest);
            Map<Cluster, String> clustersAndCommandsForJob = this.queryForClustersAndCommands(jobRequest.getCriteria().getClusterCriteria(), jobRequest.getCriteria().getCommandCriterion());
            Cluster cluster = this.selectCluster(id, jobRequest, clustersAndCommandsForJob.keySet());
            Command command = this.getCommand(clustersAndCommandsForJob.get(cluster), id);
            ArrayList applicationResources = Lists.newArrayList();
            for (Application application : this.getApplications(id, jobRequest, command)) {
                applicationResources.add(new JobSpecification.ExecutionResource(application.getId(), application.getResources()));
            }
            ArrayList commandArgs = Lists.newArrayList((Iterable)command.getExecutable());
            commandArgs.addAll(jobRequest.getCommandArgs());
            JobSpecification jobSpecification = new JobSpecification((List)commandArgs, new JobSpecification.ExecutionResource(id, jobRequest.getResources()), new JobSpecification.ExecutionResource(cluster.getId(), cluster.getResources()), new JobSpecification.ExecutionResource(command.getId(), command.getResources()), (List)applicationResources, this.generateEnvironmentVariables(id, jobRequest, cluster, command), jobRequest.getRequestedAgentConfig().isInteractive(), jobRequest.getRequestedAgentConfig().getRequestedJobDirectoryLocation().orElse(DEFAULT_JOB_DIRECTORY), this.toArchiveLocation(jobRequest.getRequestedJobArchivalData().getRequestedArchiveLocationPrefix().orElse(null), id));
            MetricsUtils.addSuccessTags(tags);
            JobSpecification jobSpecification2 = jobSpecification;
            return jobSpecification2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new RuntimeException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_SPECIFICATION_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Map<Cluster, String> queryForClustersAndCommands(List<Criterion> clusterCriteria, Criterion commandCriterion) throws GenieException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            Map<Cluster, String> clustersAndCommands = this.clusterPersistenceService.findClustersAndCommandsForCriteria(clusterCriteria, commandCriterion);
            MetricsUtils.addSuccessTags(tags);
            Map<Cluster, String> map = clustersAndCommands;
            return map;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(CLUSTER_COMMAND_QUERY_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster selectCluster(String id, com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest, Set<Cluster> clusters) throws GenieException {
        long start = System.nanoTime();
        HashSet timerTags = Sets.newHashSet();
        HashSet counterTags = Sets.newHashSet();
        try {
            if (clusters.isEmpty()) {
                this.noClusterFoundCounter.increment();
                throw new GeniePreconditionException("No cluster/command combination found for the given criteria. Unable to continue");
            }
            Cluster cluster = clusters.size() == 1 ? (Cluster)clusters.stream().findFirst().orElseThrow(() -> new GenieServerException("Couldn't get cluster when size was one")) : this.selectClusterWithLoadBalancer(counterTags, clusters, id, jobRequest);
            log.info("Selected cluster {} for job {}", (Object)cluster.getId(), (Object)id);
            MetricsUtils.addSuccessTags(timerTags);
            Cluster cluster2 = cluster;
            return cluster2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(timerTags, t);
            throw t;
        }
        finally {
            this.registry.timer(SELECT_CLUSTER_TIMER_NAME, (Iterable)timerTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Command getCommand(String commandId, String jobId) throws GenieException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            log.info("Selecting command for job {} ", (Object)jobId);
            Command command = this.commandPersistenceService.getCommand(commandId);
            log.info("Selected command {} for job {} ", (Object)commandId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            Command command2 = command;
            return command2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(SELECT_COMMAND_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private List<Application> getApplications(String id, com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest, Command command) throws GenieException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            String commandId = command.getId();
            log.info("Selecting applications for job {} and command {}", (Object)id, (Object)commandId);
            ArrayList applications = Lists.newArrayList();
            if (jobRequest.getCriteria().getApplicationIds().isEmpty()) {
                applications.addAll(this.commandPersistenceService.getApplicationsForCommand(commandId));
            } else {
                for (String applicationId : jobRequest.getCriteria().getApplicationIds()) {
                    applications.add(this.applicationPersistenceService.getApplication(applicationId));
                }
            }
            log.info("Selected applications {} for job {}", (Object)applications.stream().map(rec$ -> ((Application)rec$).getId()).reduce((one, two) -> one + "," + two).orElse(NO_ID_FOUND), (Object)id);
            MetricsUtils.addSuccessTags(tags);
            ArrayList arrayList = applications;
            return arrayList;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(SELECT_APPLICATIONS_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster selectClusterWithLoadBalancer(Set<Tag> counterTags, Set<Cluster> clusters, String id, com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest) throws GeniePreconditionException {
        Cluster cluster = null;
        for (ClusterLoadBalancer loadBalancer : this.clusterLoadBalancers) {
            Class targetClass;
            String loadBalancerClass = loadBalancer instanceof TargetClassAware ? ((targetClass = ((TargetClassAware)loadBalancer).getTargetClass()) != null ? targetClass.getCanonicalName() : loadBalancer.getClass().getCanonicalName()) : loadBalancer.getClass().getCanonicalName();
            counterTags.add(Tag.of((String)"class", (String)loadBalancerClass));
            try {
                Cluster selectedCluster = loadBalancer.selectCluster(clusters, this.toV3JobRequest(id, jobRequest));
                if (selectedCluster != null) {
                    if (clusters.contains(selectedCluster)) {
                        log.debug("Successfully selected cluster {} using load balancer {}", (Object)selectedCluster.getId(), (Object)loadBalancerClass);
                        counterTags.add(Tag.of((String)"status", (String)LOAD_BALANCER_STATUS_SUCCESS));
                        this.registry.counter(SELECT_LOAD_BALANCER_COUNTER_NAME, counterTags).increment();
                        cluster = selectedCluster;
                        break;
                    }
                    log.error("Successfully selected cluster {} using load balancer {} but it wasn't in original cluster list {}", new Object[]{selectedCluster.getId(), loadBalancerClass, clusters});
                    counterTags.add(Tag.of((String)"status", (String)LOAD_BALANCER_STATUS_INVALID));
                    this.registry.counter(SELECT_LOAD_BALANCER_COUNTER_NAME, counterTags).increment();
                    continue;
                }
                counterTags.add(Tag.of((String)"status", (String)LOAD_BALANCER_STATUS_NO_PREFERENCE));
                this.registry.counter(SELECT_LOAD_BALANCER_COUNTER_NAME, counterTags).increment();
            }
            catch (Exception e) {
                log.error("Cluster load balancer {} threw exception:", (Object)loadBalancer, (Object)e);
                counterTags.add(Tag.of((String)"status", (String)LOAD_BALANCER_STATUS_EXCEPTION));
                this.registry.counter(SELECT_LOAD_BALANCER_COUNTER_NAME, counterTags).increment();
            }
        }
        if (cluster == null) {
            this.noClusterSelectedCounter.increment();
            throw new GeniePreconditionException("Unable to select a cluster from using any of the available load balancer's.");
        }
        return cluster;
    }

    private ImmutableMap<String, String> generateEnvironmentVariables(String id, com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest, Cluster cluster, Command command) {
        ImmutableMap.Builder envVariables = ImmutableMap.builder();
        envVariables.put((Object)"GENIE_VERSION", (Object)"4");
        envVariables.put((Object)"GENIE_CLUSTER_ID", (Object)cluster.getId());
        envVariables.put((Object)"GENIE_CLUSTER_NAME", (Object)cluster.getMetadata().getName());
        envVariables.put((Object)"GENIE_CLUSTER_TAGS", (Object)this.tagsToString(cluster.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_COMMAND_ID", (Object)command.getId());
        envVariables.put((Object)"GENIE_COMMAND_NAME", (Object)command.getMetadata().getName());
        envVariables.put((Object)"GENIE_COMMAND_TAGS", (Object)this.tagsToString(command.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_ID", (Object)id);
        envVariables.put((Object)"GENIE_JOB_NAME", (Object)jobRequest.getMetadata().getName());
        envVariables.put((Object)"GENIE_JOB_MEMORY", (Object)String.valueOf(command.getMemory().orElse(this.defaultMemory)));
        envVariables.put((Object)"GENIE_JOB_TAGS", (Object)this.tagsToString(jobRequest.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_GROUPING", (Object)jobRequest.getMetadata().getGrouping().orElse(""));
        envVariables.put((Object)"GENIE_JOB_GROUPING_INSTANCE", (Object)jobRequest.getMetadata().getGroupingInstance().orElse(""));
        envVariables.put((Object)"GENIE_REQUESTED_COMMAND_TAGS", (Object)this.tagsToString(jobRequest.getCriteria().getCommandCriterion().getTags()));
        List clusterCriteria = jobRequest.getCriteria().getClusterCriteria();
        ArrayList clusterCriteriaTags = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (int i = 0; i < clusterCriteria.size(); ++i) {
            Criterion criterion = (Criterion)clusterCriteria.get(i);
            String criteriaTagsString = this.tagsToString(criterion.getTags());
            envVariables.put((Object)("GENIE_REQUESTED_CLUSTER_TAGS_" + i), (Object)criteriaTagsString);
            clusterCriteriaTags.add("[" + criteriaTagsString + "]");
        }
        envVariables.put((Object)"GENIE_REQUESTED_CLUSTER_TAGS", (Object)("[" + StringUtils.join((Iterable)clusterCriteriaTags, (char)',') + "]"));
        return envVariables.build();
    }

    private JobRequest toV3JobRequest(String id, com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest) {
        JobRequest.Builder v3Builder = (JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequest.getMetadata().getName(), jobRequest.getMetadata().getUser(), jobRequest.getMetadata().getVersion(), jobRequest.getCriteria().getClusterCriteria().stream().map(this::toClusterCriteria).collect(Collectors.toList()), this.toV3Tags(jobRequest.getCriteria().getCommandCriterion())).withId(id)).withApplications(jobRequest.getCriteria().getApplicationIds()).withCommandArgs(jobRequest.getCommandArgs()).withDisableLogArchival(jobRequest.getRequestedAgentConfig().isArchivingDisabled()).withTags(jobRequest.getMetadata().getTags());
        JobMetadata metadata = jobRequest.getMetadata();
        metadata.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withEmail(arg_0));
        metadata.getGroup().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroup(arg_0));
        metadata.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGrouping(arg_0));
        metadata.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroupingInstance(arg_0));
        metadata.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withDescription(arg_0));
        metadata.getMetadata().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withMetadata(arg_0));
        ExecutionEnvironment jobResources = jobRequest.getResources();
        v3Builder.withConfigs(jobResources.getConfigs());
        v3Builder.withDependencies(jobResources.getDependencies());
        jobResources.getSetupFile().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withSetupFile(arg_0));
        jobRequest.getRequestedAgentConfig().getTimeoutRequested().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withTimeout(arg_0));
        return v3Builder.build();
    }

    private ClusterCriteria toClusterCriteria(Criterion criterion) {
        return new ClusterCriteria(this.toV3Tags(criterion));
    }

    private Set<String> toV3Tags(Criterion criterion) {
        HashSet tags = Sets.newHashSet();
        criterion.getId().ifPresent(id -> tags.add("genie.id:" + id));
        criterion.getName().ifPresent(name -> tags.add("genie.name:" + name));
        tags.addAll(criterion.getTags());
        return tags;
    }

    private String tagsToString(Set<String> tags) {
        ArrayList sortedTags = Lists.newArrayList(tags);
        sortedTags.sort(Comparator.naturalOrder());
        String joinedString = StringUtils.join((Iterable)sortedTags, (char)',');
        return RegExUtils.replaceAll((String)RegExUtils.replaceAll((String)joinedString, (String)"'", (String)"\\'"), (String)"\"", (String)"\\\"");
    }

    private String toArchiveLocation(@Nullable String requestedArchiveLocationPrefix, String jobId) {
        if (StringUtils.isBlank((CharSequence)requestedArchiveLocationPrefix)) {
            return null;
        }
        if (requestedArchiveLocationPrefix.endsWith(File.separator)) {
            return requestedArchiveLocationPrefix + jobId;
        }
        return requestedArchiveLocationPrefix + File.separator + jobId;
    }
}

