/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.servers;

import io.grpc.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcServerManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerManager.class);
    private final Server server;

    public GRpcServerManager(Server server) {
        this.server = server;
        try {
            this.server.start();
            log.info("Successfully started gRPC server on port {}", (Object)this.server.getPort());
        }
        catch (IllegalStateException ise) {
            log.info("Server already started on port {}", (Object)this.server.getPort());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to start gRPC server on port " + this.server.getPort(), ioe);
        }
    }

    @Override
    public void close() {
        if (!this.server.isShutdown()) {
            this.server.shutdownNow();
        }
        try {
            if (this.server.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.info("Successfully shut down the gRPC server");
            } else {
                log.error("Unable to successfully shutdown the gRPC server in time allotted");
            }
        }
        catch (InterruptedException ie) {
            log.error("Unable to shutdown gRPC server due to being interrupted", (Throwable)ie);
        }
    }

    public int getServerPort() {
        return this.server.getPort();
    }
}

