/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.inspectors.impl;

import com.netflix.genie.common.internal.dto.v4.AgentClientMetadata;
import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.InspectionReport;
import com.netflix.genie.web.properties.AgentFilterProperties;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class MinimumVersionAgentMetadataInspector
implements AgentMetadataInspector {
    private final AgentFilterProperties agentFilterProperties;

    public MinimumVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        this.agentFilterProperties = agentFilterProperties;
    }

    @Override
    public InspectionReport inspect(@Valid AgentClientMetadata agentClientMetadata) {
        String minimumVersionString = this.agentFilterProperties.getMinimumVersion();
        String agentVersionString = agentClientMetadata.getVersion().orElse(null);
        if (StringUtils.isBlank((CharSequence)minimumVersionString)) {
            return InspectionReport.newAcceptance("Minimum version requirement not set");
        }
        if (StringUtils.isBlank((CharSequence)agentVersionString)) {
            return InspectionReport.newRejection("Agent version not set");
        }
        DefaultArtifactVersion minimumVersion = new DefaultArtifactVersion(minimumVersionString);
        DefaultArtifactVersion agentVersion = new DefaultArtifactVersion(agentVersionString);
        boolean deprecated = minimumVersion.compareTo((Object)agentVersion) > 0;
        return new InspectionReport(deprecated ? InspectionReport.Decision.REJECT : InspectionReport.Decision.ACCEPT, String.format("Agent version: %s is %s than minimum: %s", agentVersionString, deprecated ? "older" : "newer or equal", minimumVersionString));
    }
}

