/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.util.ExecutorFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import javax.validation.Valid;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAgentLauncherImpl
implements AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(LocalAgentLauncherImpl.class);
    private static final String SETS_ID = "setsid";
    private static final String EXEC_COMMAND = "exec";
    private static final String SERVER_HOST_OPTION = "--serverHost";
    private static final String SERVER_HOST_VALUE = "localhost";
    private static final String SERVER_PORT_OPTION = "--serverPort";
    private static final String API_JOB_OPTION = "--api-job";
    private static final String JOB_ID_OPTION = "--jobId";
    private static final String FULL_CLEANUP_OPTION = "--full-cleanup";
    private static final Object MEMORY_CHECK_LOCK = new Object();
    private final JobSearchService jobSearchService;
    private final LocalAgentLauncherProperties launcherProperties;
    private final String hostname;
    private final ExecutorFactory executorFactory;
    private final MeterRegistry registry;
    private final CommandLine commandTemplate;

    public LocalAgentLauncherImpl(GenieHostInfo hostInfo, JobSearchService jobSearchService, LocalAgentLauncherProperties launcherProperties, int agentRpcPort, ExecutorFactory executorFactory, MeterRegistry registry) {
        this.hostname = hostInfo.getHostname();
        this.jobSearchService = jobSearchService;
        this.launcherProperties = launcherProperties;
        this.executorFactory = executorFactory;
        this.registry = registry;
        String[] agentExecutable = this.launcherProperties.getExecutable().toArray(new String[0]);
        if (SystemUtils.IS_OS_LINUX) {
            this.commandTemplate = new CommandLine(SETS_ID);
            this.commandTemplate.addArguments(agentExecutable);
        } else {
            this.commandTemplate = new CommandLine(agentExecutable[0]);
            for (int i = 1; i < agentExecutable.length; ++i) {
                this.commandTemplate.addArgument(agentExecutable[i]);
            }
        }
        this.commandTemplate.addArgument(EXEC_COMMAND);
        this.commandTemplate.addArgument(SERVER_HOST_OPTION);
        this.commandTemplate.addArgument(SERVER_HOST_VALUE);
        this.commandTemplate.addArgument(SERVER_PORT_OPTION);
        this.commandTemplate.addArgument(Integer.toString(agentRpcPort));
        this.commandTemplate.addArgument(FULL_CLEANUP_OPTION);
        this.commandTemplate.addArgument(API_JOB_OPTION);
        this.commandTemplate.addArgument(JOB_ID_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchAgent(@Valid ResolvedJob resolvedJob) throws AgentLaunchException {
        log.debug("Received request to launch local agent to run job: {}", (Object)resolvedJob);
        int jobMemory = resolvedJob.getJobEnvironment().getMemory();
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        if (jobMemory > this.launcherProperties.getMaxJobMemory()) {
            throw new AgentLaunchException("Unable to launch job as the requested job memory (" + jobMemory + "MB) exceeds the maximum allowed by the configuration of the system (" + this.launcherProperties.getMaxJobMemory() + "MB)");
        }
        Object object = MEMORY_CHECK_LOCK;
        synchronized (object) {
            long usedMemoryOnHost = this.jobSearchService.getUsedMemoryOnHost(this.hostname);
            long expectedUsedMemoryOnHost = usedMemoryOnHost + (long)jobMemory;
            if (expectedUsedMemoryOnHost > this.launcherProperties.getMaxTotalJobMemory()) {
                throw new AgentLaunchException("Running job " + jobId + " with " + jobMemory + "MB of memory would cause there to be more memory used than the configured amount of " + this.launcherProperties.getMaxTotalJobMemory() + "MB. " + usedMemoryOnHost + "MB worth of jobs are currently running on this node.");
            }
        }
        Executor executor = this.executorFactory.newInstance(true);
        CommandLine commandLine = new CommandLine(this.commandTemplate);
        commandLine.addArgument(jobId);
        AgentResultHandler resultHandler = new AgentResultHandler(jobId);
        try {
            executor.execute(commandLine, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException ioe) {
            throw new AgentLaunchException("Unable to launch agent using command: " + commandLine.toString(), ioe);
        }
    }

    @VisibleForTesting
    static class AgentResultHandler
    extends DefaultExecuteResultHandler {
        private static final Logger log = LoggerFactory.getLogger(AgentResultHandler.class);
        private final String jobId;

        AgentResultHandler(String jobId) {
            this.jobId = jobId;
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            log.info("Agent process for job {} completed with exit value {}", (Object)this.jobId, (Object)exitValue);
        }

        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            log.error("Agent process failed for job {} due to {}", new Object[]{this.jobId, e.getMessage(), e});
        }
    }
}

