/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.util.GenieObjectMapper;
import com.netflix.genie.web.apis.rest.v3.controllers.DtoConverters;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ClusterResourceAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ResourceAssemblers;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.ClusterResource;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.CommandResource;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/clusters"})
public class ClusterRestController {
    private static final Logger log = LoggerFactory.getLogger(ClusterRestController.class);
    private final ClusterPersistenceService clusterPersistenceService;
    private final ClusterResourceAssembler clusterResourceAssembler;
    private final CommandResourceAssembler commandResourceAssembler;

    @Autowired
    public ClusterRestController(ClusterPersistenceService clusterPersistenceService, ResourceAssemblers resourceAssemblers) {
        this.clusterPersistenceService = clusterPersistenceService;
        this.clusterResourceAssembler = resourceAssemblers.getClusterResourceAssembler();
        this.commandResourceAssembler = resourceAssemblers.getCommandResourceAssembler();
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createCluster(@RequestBody @Valid Cluster cluster) throws GenieException {
        log.info("Called to create new cluster {}", (Object)cluster);
        String id = this.clusterPersistenceService.createCluster(DtoConverters.toV4ClusterRequest(cluster));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ClusterResource getCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id: {}", (Object)id);
        return this.clusterResourceAssembler.toResource(DtoConverters.toV3Cluster(this.clusterPersistenceService.getCluster(id)));
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<ClusterResource> getClusters(@RequestParam(value="name", required=false) @Nullable String name, @RequestParam(value="status", required=false) @Nullable Set<String> statuses, @RequestParam(value="tag", required=false) @Nullable Set<String> tags, @RequestParam(value="minUpdateTime", required=false) @Nullable Long minUpdateTime, @RequestParam(value="maxUpdateTime", required=false) @Nullable Long maxUpdateTime, @PageableDefault(size=64, sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<Cluster> assembler) throws GenieException {
        Page clusters;
        log.info("Called to find clusters [name | statuses | tags | minUpdateTime | maxUpdateTime | page]\n{} | {} | {} | {} | {} | {}", new Object[]{name, statuses, tags, minUpdateTime, maxUpdateTime, page});
        EnumSet<ClusterStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(ClusterStatus.class);
            for (String status : statuses) {
                enumStatuses.add(ClusterStatus.parse((String)status));
            }
        }
        if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.id:")).count() >= 1L) {
            ArrayList clusterList = Lists.newArrayList();
            int prefixLength = "genie.id:".length();
            tags.stream().filter(tag -> tag.startsWith("genie.id:")).forEach(tag -> {
                String id = tag.substring(prefixLength);
                try {
                    clusterList.add(DtoConverters.toV3Cluster(this.clusterPersistenceService.getCluster(id)));
                }
                catch (GenieException ge) {
                    log.debug("No cluster with id {} found", (Object)id, (Object)ge);
                }
            });
            clusters = new PageImpl((List)clusterList);
        } else if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.name:")).count() >= 1L) {
            Set<String> finalTags = tags.stream().filter(tag -> !tag.startsWith("genie.name:")).collect(Collectors.toSet());
            if (name == null) {
                Optional<String> finalName = tags.stream().filter(tag -> tag.startsWith("genie.name:")).map(tag -> tag.substring("genie.name:".length())).findFirst();
                clusters = this.clusterPersistenceService.getClusters(finalName.orElse(null), enumStatuses, finalTags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
            } else {
                clusters = this.clusterPersistenceService.getClusters(name, enumStatuses, finalTags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
            }
        } else {
            clusters = this.clusterPersistenceService.getClusters(name, enumStatuses, tags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
        }
        Link self = ControllerLinkBuilder.linkTo(((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getClusters(name, statuses, tags, minUpdateTime, maxUpdateTime, page, assembler)).withSelfRel();
        return assembler.toResource(clusters, (ResourceAssembler)this.clusterResourceAssembler, self);
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCluster(@PathVariable(value="id") String id, @RequestBody Cluster updateCluster) throws GenieException {
        log.info("Called to update cluster with id {} update fields {}", (Object)id, (Object)updateCluster);
        this.clusterPersistenceService.updateCluster(id, DtoConverters.toV4Cluster(updateCluster));
    }

    @PatchMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchCluster(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.info("Called to patch cluster {} with patch {}", (Object)id, (Object)patch);
        Cluster currentCluster = DtoConverters.toV3Cluster(this.clusterPersistenceService.getCluster(id));
        try {
            log.debug("Will patch cluster {}. Original state: {}", (Object)id, (Object)currentCluster);
            JsonNode clusterNode = GenieObjectMapper.getMapper().valueToTree((Object)currentCluster);
            JsonNode postPatchNode = patch.apply(clusterNode);
            Cluster patchedCluster = (Cluster)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, Cluster.class);
            log.debug("Finished patching cluster {}. New state: {}", (Object)id, (Object)patchedCluster);
            this.clusterPersistenceService.updateCluster(id, DtoConverters.toV4Cluster(patchedCluster));
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch cluster {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Delete cluster called for id: {}", (Object)id);
        this.clusterPersistenceService.deleteCluster(id);
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllClusters() throws GenieException {
        log.warn("Delete all clusters called");
        this.clusterPersistenceService.deleteAllClusters();
    }

    @PostMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and config {}", (Object)id, configs);
        this.clusterPersistenceService.addConfigsForCluster(id, configs);
    }

    @GetMapping(value={"/{id}/configs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.clusterPersistenceService.getConfigsForCluster(id);
    }

    @PutMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and configs {}", (Object)id, configs);
        this.clusterPersistenceService.updateConfigsForCluster(id, configs);
    }

    @DeleteMapping(value={"/{id}/configs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.clusterPersistenceService.removeAllConfigsForCluster(id);
    }

    @PostMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addDependenciesForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.clusterPersistenceService.addDependenciesForCluster(id, dependencies);
    }

    @GetMapping(value={"/{id}/dependencies"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getDependenciesForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.clusterPersistenceService.getDependenciesForCluster(id);
    }

    @PutMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDependenciesForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.clusterPersistenceService.updateDependenciesForCluster(id, dependencies);
    }

    @DeleteMapping(value={"/{id}/dependencies"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllDependenciesForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.clusterPersistenceService.removeAllDependenciesForCluster(id);
    }

    @PostMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and tags {}", (Object)id, tags);
        this.clusterPersistenceService.addTagsForCluster(id, tags);
    }

    @GetMapping(value={"/{id}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return DtoConverters.toV3Cluster(this.clusterPersistenceService.getCluster(id)).getTags();
    }

    @PutMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and tags {}", (Object)id, tags);
        this.clusterPersistenceService.updateTagsForCluster(id, tags);
    }

    @DeleteMapping(value={"/{id}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.clusterPersistenceService.removeAllTagsForCluster(id);
    }

    @DeleteMapping(value={"/{id}/tags/{tag}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForCluster(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.info("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.clusterPersistenceService.removeTagForCluster(id, tag);
    }

    @PostMapping(value={"/{id}/commands"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) throws GenieException {
        log.info("Called with id {} and commandIds {}", (Object)id, commandIds);
        this.clusterPersistenceService.addCommandsForCluster(id, commandIds);
    }

    @GetMapping(value={"/{id}/commands"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<CommandResource> getCommandsForCluster(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) @Nullable Set<String> statuses) throws GenieException {
        log.info("Called with id {} status {}", (Object)id, statuses);
        EnumSet<CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(CommandStatus.parse((String)status));
            }
        }
        return this.clusterPersistenceService.getCommandsForCluster(id, enumStatuses).stream().map(DtoConverters::toV3Command).map(this.commandResourceAssembler::toResource).collect(Collectors.toList());
    }

    @PutMapping(value={"/{id}/commands"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) throws GenieException {
        log.info("Called with id {} and commandIds {}", (Object)id, commandIds);
        this.clusterPersistenceService.setCommandsForCluster(id, commandIds);
    }

    @DeleteMapping(value={"/{id}/commands"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllCommandsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.clusterPersistenceService.removeAllCommandsForCluster(id);
    }

    @DeleteMapping(value={"/{id}/commands/{commandId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeCommandForCluster(@PathVariable(value="id") String id, @PathVariable(value="commandId") String commandId) throws GenieException {
        log.info("Called with id {} and command id {}", (Object)id, (Object)commandId);
        this.clusterPersistenceService.removeCommandForCluster(id, commandId);
    }
}

