/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.ApplicationRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.ApplicationResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class ApplicationResourceAssembler
implements ResourceAssembler<Application, ApplicationResource> {
    private static final String COMMANDS_LINK = "commands";

    public ApplicationResource toResource(Application application) {
        String id = (String)application.getId().orElseThrow(IllegalArgumentException::new);
        ApplicationResource applicationResource = new ApplicationResource(application);
        try {
            applicationResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getApplication(id))).withSelfRel());
            applicationResource.add(ControllerLinkBuilder.linkTo(((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getCommandsForApplication(id, null)).withRel(COMMANDS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return applicationResource;
    }
}

