/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.ClusterRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.ClusterResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class ClusterResourceAssembler
implements ResourceAssembler<Cluster, ClusterResource> {
    private static final String COMMANDS_LINK = "commands";

    public ClusterResource toResource(Cluster cluster) {
        String id = (String)cluster.getId().orElseThrow(IllegalArgumentException::new);
        ClusterResource clusterResource = new ClusterResource(cluster);
        try {
            clusterResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCluster(id))).withSelfRel());
            clusterResource.add(ControllerLinkBuilder.linkTo(((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCommandsForCluster(id, null)).withRel(COMMANDS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return clusterResource;
    }
}

