/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.JobExecutionResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class JobExecutionResourceAssembler
implements ResourceAssembler<JobExecution, JobExecutionResource> {
    private static final String JOB_LINK = "job";
    private static final String REQUEST_LINK = "request";
    private static final String OUTPUT_LINK = "output";
    private static final String STATUS_LINK = "status";
    private static final String METADATA_LINK = "metadata";

    public JobExecutionResource toResource(JobExecution jobExecution) {
        String id = (String)jobExecution.getId().orElseThrow(IllegalArgumentException::new);
        JobExecutionResource jobExecutionResource = new JobExecutionResource(jobExecution);
        try {
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id))).withSelfRel());
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id))).withRel(JOB_LINK));
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id))).withRel(REQUEST_LINK));
            jobExecutionResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)OUTPUT_LINK)).withRel(OUTPUT_LINK));
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel(STATUS_LINK));
            jobExecutionResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id))).withRel(METADATA_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobExecutionResource;
    }
}

