/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.JobMetadataResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class JobMetadataResourceAssembler
implements ResourceAssembler<JobMetadata, JobMetadataResource> {
    private static final String JOB_LINK = "job";
    private static final String REQUEST_LINK = "request";
    private static final String OUTPUT_LINK = "output";
    private static final String STATUS_LINK = "status";
    private static final String EXECUTION_LINK = "execution";

    public JobMetadataResource toResource(JobMetadata jobMetadata) {
        String id = (String)jobMetadata.getId().orElseThrow(IllegalArgumentException::new);
        JobMetadataResource jobMetadataResource = new JobMetadataResource(jobMetadata);
        try {
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id))).withSelfRel());
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id))).withRel(JOB_LINK));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id))).withRel(REQUEST_LINK));
            jobMetadataResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)OUTPUT_LINK)).withRel(OUTPUT_LINK));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel(STATUS_LINK));
            jobMetadataResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id))).withRel(EXECUTION_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobMetadataResource;
    }
}

