/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.JobRequestResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class JobRequestResourceAssembler
implements ResourceAssembler<JobRequest, JobRequestResource> {
    private static final String JOB_LINK = "job";
    private static final String EXECUTION_LINK = "execution";
    private static final String OUTPUT_LINK = "output";
    private static final String STATUS_LINK = "status";
    private static final String METADATA_LINK = "metadata";

    public JobRequestResource toResource(JobRequest jobRequest) {
        String id = (String)jobRequest.getId().orElseThrow(IllegalArgumentException::new);
        JobRequestResource jobRequestResource = new JobRequestResource(jobRequest);
        try {
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id))).withSelfRel());
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id))).withRel(JOB_LINK));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id))).withRel(EXECUTION_LINK));
            jobRequestResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)OUTPUT_LINK)).withRel(OUTPUT_LINK));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel(STATUS_LINK));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id))).withRel(METADATA_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobRequestResource;
    }
}

